-- .local~log4r.config.asyncMode=.true
say ' The beginning: '~center(50, "-") /* draw a line    */
-- .local~log4r.config.LogLog.debug=.true

call load_log4rexx      /* load the 'log4rexx' framework    */

l=.logManager~getLogger("rgf.test") /* get (create?) a logger named 'rgf.test'   */

   /* configure the logger a little bit:  */
app=.FileAppender~new("test.rgf.app")        /* create an appender         */
app~layout=.HTMLLayout~new("test.rgf.layout")/* create a layout and assign it to appender */
app~fileName="test_"date("S")".html"         /* set filename               */
app~append=.false                            /* replace an existing file   */
l~addAppender(app)                           /* add appender to logger     */

.local~test.rgf.logger=l   /* save logger in .local, even easier to refer to  */

l~debug("appender created at runtime:" pp(app~name":" getLogLevelAsString(app~threshold)))

parse arg logLevel
if logLevel="" then l~logLevel="OFF"      /* do not show any log messages     */
               else l~logLevel=logLevel   /* set logLevel to argument's value */

l~debug("just created a logger named 'rgf.test':" pp(l~string))

parse source s          /* get source information        */
l~trace("source:" pp(s))

p=.person~new("Peedin", "Lee", 250000) /* create a person*/
say "p="pp(p~string)    /* pp() defined in 'log4rexx' framework   */
p~increaseSalary(12345.67) /* increase salary            */
p~increaseSalary("abc")    /* provoke an error           */
p~increaseSalary(-1000)    /* decrease salary            */
drop p      /* drop reference, allow object to be garbage collected  */

say ' The end. '~center(50, "-") /* draw a line          */
l~trace("end of program.")

/* ================================================================= */
::class person          /* class "PERSON"                */

/* ----------------------------------------------------- */
::method init           /* method "INIT" (constructor)   */
  expose familyName firstName salary

  .test.rgf.logger~trace("method 'init'")

  use arg familyName, firstName, salary
  .test.rgf.logger~debug("method 'init' - created the following person:" pp(self~string))

  if salary>10000 then  -- warn about something
     .test.rgf.logger~warn("method 'init' - salary quite high:" salary)


::method familyName     attribute
::method firstName      attribute
::method salary         attribute

/* ----------------------------------------------------- */
::method string
  expose familyName firstName salary

  .test.rgf.logger~trace("method 'string'")
  return familyName"," firstName":" salary

/* ----------------------------------------------------- */
::method increaseSalary /* method to increase the salary */
  expose salary
  .test.rgf.logger~trace("method 'increaseSalary'")

  parse arg raise
  .test.rgf.logger~debug("method 'increaseSalary', received="pp(raise))

  signal on syntax      /* in case arithmetic creates a condition    */
  salary=salary+raise
  .test.rgf.logger~debug("method 'increaseSalary', new salary="pp(salary))
  return

syntax:
  .test.rgf.logger~error("method 'increaseSalary', exception has occurred!", condition("O"))

/* ----------------------------------------------------- */
::method uninit
  .test.rgf.logger~trace("method 'uninit'")
  .test.rgf.logger~debug("method 'uninit' running for person:" pp(self))


