/* demo_wrapper.rex */
    call SysCls
    parse source . . ourname
    signal on syntax
    system_name = value("COMPUTERNAME",,"ENVIRONMENT")

say 'Step 1 - Use ~connect() to establish the MySQL connection'
    connection_handle = 'c1'
    osql     = .rxsqlwrapper~new(connection_handle)
    dsn      = 'leegreen'
    database = 'rexxla'
    con_str  = dsn';database='database
    if osql~connect(con_str) < 0 then call mySQLError .false
    say '   Connection Successful'
    pull
    say '-'~copies(175)

say 'Step 2 - Drop the table if it already exists'
    tablename = 'asampletable1'
    ss = 'drop table if exists' tablename
    say '   'ss
    if osql~execute(ss,.true) then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 3 - Use ~execute To Create Our Table'
    ss = "create table" tablename"(uid int not null auto_increment, edate date not null," ,
         "etime time not null, etype varchar(3)," ,
         "edescription varchar(25)," ,
         "primary key(uid)) engine=InnoDB"
    say '   'ss
    if osql~execute(ss,.true) < 0 then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 4 - Use ~execute To Add A Couple Of Rows To Our Table'
    ss = "insert into" tablename "set edate = '"date('s')"', etime = '"time('n')"', etype = 'F'," ,
         "edescription = 'Using ooRexx date/time'"
    say '   'ss
    if osql~execute(ss,.true) \= 0 then call mySQLError .false
    say 'Sleep for 2 seconds so curtime() has a chance to increment'
    call SysSleep(2)
    say 'Sleeping Finished'
    ss = "insert into" tablename "set edate = curdate(), etime = curtime(), etype = 'F'," ,
         "edescription = 'Using SQL curdate/curtime'"
    say '   'ss
    if osql~execute(ss,.true) \= 0 then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 5 - Use ~execute To Add A Few More Rows In A Transaction'
    ss = "insert into" tablename "set edate = '"'20070429'"', etime = '"'13:00:00'"', etype = 'S'," ,
         "edescription = '2007 Symposium Start'"
    say '   'ss
    if osql~execute(ss,.false) \= 0 then call mySQLError .false
    ss = "insert into" tablename "set edate = '"'20070503'"', etime = '"'12:00:00'"'," ,
         "edescription = '2007 Symposium End'"
    say '   'ss
    if osql~execute(ss,.false) \= 0 then call mySQLError .false
    ss = "insert into" tablename "set edate = '"'20060409'"', etime = '"'13:00:00'"'," ,
         "edescription = '2006 Symposium Start'"
    say '   'ss
    if osql~execute(ss,.false) \= 0 then call mySQLError .false
    ss = "insert into" tablename "set edate = '"'20060413'"', etime = '"'12:00:00'"'," ,
         "edescription = '2006 Symposium End'"
    say '   'ss
    if osql~execute(ss,.false) \= 0 then call mySQLError .false
    pull

say 'Step 6 - Use ~commit() To Commit Our Transaction'
    if osql~commit() \= 0 then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 7 - Use ~query To Find Any Rows Where etype is NULL'
    ss = "select * from" tablename "where etype is null"
    say '   'ss
    if osql~query(ss) \= 0 then call mySQLError .false
    null_count = osql~rowcount
    say '   There is/are' null_count 'row(s) with a NULL value in etype'
    pull
    say '-'~copies(175)

say 'Step 8 - Use ~execute To Update Any Row Where etype is NULL - set it to S'
    ss = "update" tablename "set etype = 'S' where etype is null"
    say '   'ss
    if osql~execute(ss,.true) \= 0 then call mySQLError .false
    update_counter = osql~rowcount
    say '   Updated' update_counter 'Rows'
    pull
    say '-'~copies(175)

say 'Step 9 - Use ~query To Retrieve All Data On All Rows'
    ss = "select * from" tablename
    say '   'ss
    if osql~query(ss) \= 0 then call mySQLError .false
    all_events = osql~rows
    ae_ctr     = osql~rowcount
    say '   Our Table Has' ae_ctr 'Rows'
    say
    say 'UID' 'Date'~left(10) 'Time'~left(8) 'Type'~left(4) 'Description'~left(25)
    say '-'~copies(3) '-'~copies(10) '-'~copies(8) '-'~copies(4) '-'~copies(25)
    do i = 1 to all_events~items
        dline = all_events[i]['uid']~left(3) all_events[i]['edate']~left(10),
                all_events[i]['etime'] all_events[i]['etype']~left(4),
                all_events[i]['edescription']~left(25)
        say dline
    end
    pull
    say '-'~copies(175)

say 'Step 10 - Use ~query To Retrieve All Data On All Rows Again, But Let SQL Sort The Results By Event Date - Ascending'
    ss = "select * from" tablename "order by edate"
    say '   'ss
    if osql~query(ss) \= 0 then call mySQLError .false
    all_events = osql~rows
    ae_ctr     = osql~rowcount
    say '   Our Table Has' ae_ctr 'Rows'
    say
    say 'UID' 'Date'~left(10) 'Time'~left(8) 'Type'~left(4) 'Description'~left(25)
    say '-'~copies(3) '-'~copies(10) '-'~copies(8) '-'~copies(4) '-'~copies(25)
    do i = 1 to all_events~items
        dline = all_events[i]['uid']~left(3) all_events[i]['edate']~left(10),
                all_events[i]['etime'] all_events[i]['etype']~left(4),
                all_events[i]['edescription']~left(25)
        say dline
    end
    pull
    say '-'~copies(175)

say 'Step 11 - Use ~query To Retrieve All Data On All Rows Again, But Let SQL Sort The Results By Event Date - Descending'
    ss = "select * from" tablename "order by edate desc, etime"
    say '   'ss
    if osql~query(ss) \= 0 then call mySQLError .false
    all_events = osql~rows
    ae_ctr     = osql~rowcount
    say '   Our Table Has' ae_ctr 'Rows'
    say
    say 'UID' 'Date'~left(10) 'Time'~left(8) 'Type'~left(4) 'Description'~left(25)
    say '-'~copies(3) '-'~copies(10) '-'~copies(8) '-'~copies(4) '-'~copies(25)
    do i = 1 to all_events~items
        dline = all_events[i]['uid']~left(3) all_events[i]['edate']~left(10),
                all_events[i]['etime'] all_events[i]['etype']~left(4),
                all_events[i]['edescription']~left(25)
        say dline
    end
    pull
    say '-'~copies(175)

say 'Step 12 - Use ~query And A Little SQL "Magic" To Find Any Event Over 300 Days Old'
    ss = "select edate, datediff(curdate(),edate) as age from" tablename "having age > 300"
    say '   'ss
    if osql~query(ss) \= 0 then call mySQLError .false
    old_events = osql~rows
    oe_ctr     = osql~rowcount
    say '   There Are' oe_ctr 'Rows With Events Over 300 Days'
    say
    say 'Date'~left(10) 'Age'~left(5)
    say '-'~copies(10) '-'~copies(5)
    do i = 1 to oe_ctr
        say old_events[i]['edate']~left(10) old_events[i]['age']
    end
    pull
    say '-'~copies(175)

say 'Step 13 - Use The "Magic" Again And Delete All Rows Whose Event Is Over 300 Days'
    ss = "delete from" tablename "where datediff(curdate(),edate) > 300"
    say '   'ss
    if osql~execute(ss,.true) \= 0 then call mySQLError .false
    del_ctr = osql~rowcount
    say '   'del_ctr 'Rows Deleted'
    pull
    say '-'~copies(175)

say 'Step 14 - Use ~variable To Retrieve A SQL Variable'
    if osql~variable('version') < 0 then call mySQLError .false
    say '    Using Rexx/SQL Version........:' osql~vardir['version']
    say
    pull
    say '-'~copies(175)

say 'Step 15 - Use ~variable To Retrieve ALL SQL Variables'
    if osql~variable('ALL') < 0 then call mySQLError .false
    do i over osql~vardir
        say '   'i~left(20) osql~vardir[i]
    end
    pull
    say '-'~copies(175)

say 'Step 16 - Use ~variable To Set The NULLSTRINGOUT Variable'
    ss = "insert into" tablename "set edate = '"'20080113'"', etime = '"'16:00:00'"'," ,
         "edescription = 'Leave etype null'"
    say '   'ss
    if osql~execute(ss,.true) \= 0 then call mySQLError .false
    if osql~variable('nullstringout') < 0 then call mySQLError .false
    say '   NullStringOut Before Set >'osql~vardir['nullstringout']'<'
    say
    ss = "select edate,etype from" tablename "where etype is null"
    say '   'ss
    if osql~query(ss) \= 0 then call mySQLError .false
    rows = osql~rows
    do i = 1 to rows~items
        say '   'rows[i]['edate'] '>'rows[i]['etype']'<'
    end
    say
    if osql~variable('nullstringout','Empty') < 0 then call mySQLError .false
    if osql~variable('nullstringout') < 0 then call mySQLError .false
    say '   NullStringOut After  Set >'osql~vardir['nullstringout']'<'
    if osql~query(ss) \= 0 then call mySQLError .false
    rows = osql~rows
    do i = 1 to rows~items
        say '   'rows[i]['edate'] '>'rows[i]['etype']'<'
    end
    pull
    say '-'~copies(175)

say 'Step 17 - Use ~execute To Execute An Invalid SQL Statment'
    ss = "insert into" tablename "set edate = '"'20071231'"', etime = '"'23:59:00'"'," ,
         "edescription = 'This is a string that is too long to fit in the column'"
    say '   'ss
    if osql~execute(ss,.false) \= 0 then call mySQLError .true
    say
    say '   We showed our error, but the program has continued'
    pull
    say '-'~copies(175)

say 'Step 18 - Connect to a different database'
    connection_handle = 'c2'
    osql2    = .rxsqlwrapper~new(connection_handle)
    dsn      = 'leegreen'
    database = 'chch'
    con_str  = dsn';database='database
    if osql2~connect(con_str) < 0 then call mySQLError .false
    say '   Connection Successful'
    pull
    say '-'~copies(175)

say 'Step 19 - Retrive an alias value from a table in the newly connected database'
    ss = "select max(hkey) as max_hkey from history"
    say '   'ss
    if osql2~query(ss) \= 0 then call mySQLError .false
    rowcount = osql2~rowcount
    rows     = osql2~rows
    do i = 1 to rowcount
        say '   Max Value of hkey from history is' rows[i]['max_hkey']~strip('l','0')
    end
    pull
    say '-'~copies(175)

say 'Step 20 - Use ~disconnect to disconnect from both MySQL connections'
    if osql~disconnect() < 0 then call mySQLError .false
    say 'Disconnect of c1 Successful'
    if osql2~disconnect() < 0 then call mySQLError .false
    say 'Disconnect of c2 Successful'
exit

mySQLError: procedure expose osql sigl ourname system_name
    use arg kontinue
    say
    sql_errors = .array~new
    sql_errors[sql_errors~items+1] = 'SQL Error!'
    sql_errors[sql_errors~items+1] = 'ApplicationBeingExecuted' ourname
    sql_errors[sql_errors~items+1] = 'SqlErrorOnLine' SIGL
    sql_errors[sql_errors~items+1] = 'DateOfError' date('s')
    sql_errors[sql_errors~items+1] = 'TimeOfError' time('n')
    sql_errors[sql_errors~items+1] = 'UserID' userid()
    sql_errors[sql_errors~items+1] = 'System' system_name

    do x over osql~details
        if x~translate = 'SQLERRM' then
            parse value osql~details[x] with .']'.']'.']'emsg
        else
            emsg = osql~details[x]
        sql_errors[sql_errors~items+1] = x emsg
    end
    call SayErrors sql_errors
    if \kontinue then
        do
            if symbol('osql') = 'VAR' then
                osql~~rollback()~disconnect()
            say 'We Died An SQL Death'
            exit
        end
    say
return

Syntax:
    syntax_errors = .array~new
    obj = condition('o')
    rc2 = ''
    do x over obj
        select
            when x = 'RC' then rc1 = obj[x]
            when x = 'CODE' then rc2 = obj[x]
            when x = 'MESSAGE' then et2 = obj[x]
            otherwise nop
        end
    end
    syntax_errors[syntax_errors~items+1] = 'Syntax Error!'
    syntax_errors[syntax_errors~items+1] = 'ApplicationBeingExecuted' ourname
    syntax_errors[syntax_errors~items+1] = 'SyntaxErrorOnLine' SIGL
    syntax_errors[syntax_errors~items+1] = 'SourceLine' sourceline(sigl)~strip
    syntax_errors[syntax_errors~items+1] = 'Error' rc1~left(6)':' errortext(rc1)
    if rc2 \= '' then syntax_errors[syntax_errors~items+1] = 'SubError' rc2~left(6)':' et2
    syntax_errors[syntax_errors~items+1] = 'DateOfError' date('s')
    syntax_errors[syntax_errors~items+1] = 'TimeOfError' time('n')
    syntax_errors[syntax_errors~items+1] = 'UserID' userid()
    syntax_errors[syntax_errors~items+1] = 'System' system_name
    if symbol('osql') = 'VAR' then
        osql~~rollback()~disconnect()
    call SayErrors syntax_errors
    say 'We Died A Syntax Death'
exit

SayErrors: procedure
    use arg error_array
    do i = 1 to error_array~items
        say error_array[i]~word(1)~left(26,'.')':' error_array[i]~subword(2)
    end
return
::requires 'c:\2007Symposium\SQL_Presentation\RxSQLWrapper.cls'