/* demo_procedural.rex */
    call SysCls
    parse source . . ourname
    signal on syntax
    system_name = value("COMPUTERNAME",,"ENVIRONMENT")

say 'Step 1 - Establish the MySQL connection'
    if rxfuncquery('SQLLoadFuncs') then call rxfuncadd 'SQLLoadFuncs', 'rexxsql'
    if rxfuncquery('sqlconnect') then call sqlloadfuncs
    varlist    = .array~of('VERSION','DEBUG','ROWLIMIT','LONGLIMIT','SAVESQL','AUTOCOMMIT','IGNORETRUNCATE', -
                           'NULLSTRINGOUT','NULLSTRINGIN','STANDARDPLACEMARKERS','SUPPORTSPLACEMARKERS', -
                           'SUPPORTSDMLROWCOUNT','SUPPORTSTHREADS')
    connection_handle = 'c1'
    dsn      = 'leegreen'
    database = 'rexxla'
    con_str  = dsn';database='database
    if sqlconnect(connection_handle,,,, 'dsn='con_str) < 0 then call mySQLError .false
    say '   Connection Successful'
    pull
    say '-'~copies(175)

say 'Step 2 - Drop the table if it already exists'
    tablename = 'asampletable2'
    ss = 'drop table if exists' tablename
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqlcommit() < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 3 - Create Our Table'
    ss = "create table" tablename"(uid int not null auto_increment, edate date not null," ,
         "etime time not null, etype varchar(3)," ,
         "edescription varchar(25)," ,
         "primary key(uid)) engine=InnoDB"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqlcommit() < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 4 - Add A Couple Of Rows To Our Table'
    ss = "insert into" tablename "set edate = '"date('s')"', etime = '"time('n')"', etype = 'F'," ,
         "edescription = 'Using ooRexx date/time'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqlcommit() < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    say 'Sleep for 2 seconds so curtime() has a chance to increment'
    call SysSleep(2)
    say 'Sleeping Finished'
    ss = "insert into" tablename "set edate = curdate(), etime = curtime(), etype = 'F'," ,
         "edescription = 'Using SQL curdate/curtime'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqlcommit() < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 5 - Add A Few More Rows In A Transaction'
    ss = "insert into" tablename "set edate = '"'20070429'"', etime = '"'13:00:00'"', etype = 'S'," ,
         "edescription = '2007 Symposium Start'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    ss = "insert into" tablename "set edate = '"'20070503'"', etime = '"'12:00:00'"'," ,
         "edescription = '2007 Symposium End'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    ss = "insert into" tablename "set edate = '"'20060409'"', etime = '"'13:00:00'"'," ,
         "edescription = '2006 Symposium Start'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    ss = "insert into" tablename "set edate = '"'20060413'"', etime = '"'12:00:00'"'," ,
         "edescription = '2006 Symposium End'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    pull

say 'Step 6 - Commit() To Commit Our Transaction'
    if sqlcommit() < 0 then call mySQLError .false
    pull
    say '-'~copies(175)

say 'Step 7 - Find Any Rows Where etype is NULL'
    ss = "select * from" tablename "where etype is null"
    say '   'ss
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    null_count = next_rows
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    say '   There is/are' null_count 'row(s) with a NULL value in etype'
    pull
    say '-'~copies(175)

say 'Step 8 - Update Any Row Where etype is NULL - set it to S'
    ss = "update" tablename "set etype = 'S' where etype is null"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqlcommit() < 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    update_counter = sqlca.rowcount
    say '   Updated' update_counter 'Rows'
    pull
    say '-'~copies(175)

say 'Step 9 - Retrieve All Data On All Rows'
    ss = "select * from" tablename
    say '   'ss
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    ae_ctr = next_rows
    say '   Our Table Has' ae_ctr 'Rows'
    say
    say 'UID' 'Date'~left(10) 'Time'~left(8) 'Type'~left(4) 'Description'~left(25)
    say '-'~copies(3) '-'~copies(10) '-'~copies(8) '-'~copies(4) '-'~copies(25)
    do i = 1 to rows~items
        dline = rows[i]['uid']~left(3) rows[i]['edate']~left(10),
                rows[i]['etime'] rows[i]['etype']~left(4),
                rows[i]['edescription']~left(25)
        say dline
    end
    pull
    say '-'~copies(175)

say 'Step 10 - Retrieve All Data On All Rows Again, But Let SQL Sort The Results By Event Date - Ascending'
    ss = "select * from" tablename "order by edate"
    say '   'ss
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    ae_ctr = next_rows
    say '   Our Table Has' ae_ctr 'Rows'
    say
    say 'UID' 'Date'~left(10) 'Time'~left(8) 'Type'~left(4) 'Description'~left(25)
    say '-'~copies(3) '-'~copies(10) '-'~copies(8) '-'~copies(4) '-'~copies(25)
    do i = 1 to rows~items
        dline = rows[i]['uid']~left(3) rows[i]['edate']~left(10),
                rows[i]['etime'] rows[i]['etype']~left(4),
                rows[i]['edescription']~left(25)
        say dline
    end
    pull
    say '-'~copies(175)

say 'Step 11 - Retrieve All Data On All Rows Again, But Let SQL Sort The Results By Event Date - Descending'
    ss = "select * from" tablename "order by edate desc, etime"
    say '   'ss
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    ae_ctr = next_rows
    say '   Our Table Has' ae_ctr 'Rows'
    say
    say 'UID' 'Date'~left(10) 'Time'~left(8) 'Type'~left(4) 'Description'~left(25)
    say '-'~copies(3) '-'~copies(10) '-'~copies(8) '-'~copies(4) '-'~copies(25)
    do i = 1 to rows~items
        dline = rows[i]['uid']~left(3) rows[i]['edate']~left(10),
                rows[i]['etime'] rows[i]['etype']~left(4),
                rows[i]['edescription']~left(25)
        say dline
    end
    pull
    say '-'~copies(175)

say 'Step 12 - A Little SQL "Magic" To Find Any Event Over 300 Days Old'
    ss = "select edate, datediff(curdate(),edate) as age from" tablename "having age > 300"
    say '   'ss
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    oe_ctr = next_rows
    say '   There Are' oe_ctr 'Rows With Events Over 300 Days'
    say
    say 'Date'~left(10) 'Age'~left(5)
    say '-'~copies(10) '-'~copies(5)
    do i = 1 to oe_ctr
        say rows[i]['edate']~left(10) rows[i]['age']
    end
    pull
    say '-'~copies(175)

say 'Step 13 - Use The "Magic" Again And Delete All Rows Whose Event Is Over 300 Days'
    ss = "delete from" tablename "where datediff(curdate(),edate) > 300"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqlcommit() \= 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    del_ctr = sqlca.rowcount
    say '   'del_ctr 'Rows Deleted'
    pull
    say '-'~copies(175)

say 'Step 14 - Use sqlvariable To Retrieve A SQL Variable'
    say '    Using Rexx/SQL Version........:' sqlvariable('version')
    say
    pull
    say '-'~copies(175)

say 'Step 15 - Use sqlvariable To Retrieve ALL SQL Variables'
    do i over varlist
        say '   'i~left(20) sqlvariable(i)
    end
    pull
    say '-'~copies(175)

say 'Step 16 - Set The NULLSTRINGOUT Variable'
    ss = "insert into" tablename "set edate = '"'20080113'"', etime = '"'16:00:00'"'," ,
         "edescription = 'Leave etype null'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .false
    if sqlcommit() \= 0 then call mySQLError .false
    if sqldispose('e1') < 0 then call mySQLError .false
    say '   NullStringOut Before Set >'sqlvariable('nullstringout')'<'
    say
    ss = "select edate,etype from" tablename "where etype is null"
    say '   'ss
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    do i = 1 to rows~items
        say '   'rows[i]['edate'] '>'rows[i]['etype']'<'
    end
    say
    if sqlvariable('nullstringout','Empty') < 0 then call mySQLError .false
    say '   NullStringOut After  Set >'sqlvariable('nullstringout')'<'
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    do i = 1 to rows~items
        say '   'rows[i]['edate'] '>'rows[i]['etype']'<'
    end
    pull
    say '-'~copies(175)

say 'Step 17 - Execute An Invalid SQL Statment'
    ss = "insert into" tablename "set edate = '"'20071231'"', etime = '"'23:59:00'"'," ,
         "edescription = 'This is a string that is too long to fit in the column'"
    say '   'ss
    if sqlprepare('e1',ss) < 0 then call mySQLError .false
    if sqlexecute('e1') < 0 then call mySQLError .true
    if sqldispose('e1') < 0 then call mySQLError .false
    say
    say '   We showed our error, but the program has continued'
    pull
    say '-'~copies(175)

say 'Step 18 - Connect to a different database'
    connection_handle = 'c2'
    dsn      = 'leegreen'
    database = 'chch'
    con_str  = dsn';database='database
    if sqlconnect(connection_handle,,,, 'dsn='con_str) < 0 then call mySQLError .false
    say '   Connection Successful'
    pull
    say '-'~copies(175)

say 'Step 19 - Retrieve an alias value from a table in the newly connected database'
    if sqldefault('c2') < 0 then call mySQLError .false
    ss = "select max(hkey) as max_key from history"
    say '   'ss
    if sqlprepare('q1',ss) < 0 then call mySQLError .false
    if sqlopen('q1') < 0 then call mySQLError .false
    rows = .array~new()
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then call mySQLError .false
        if rv = 0 then leave
        next_rows = rows~items + 1
        rows[next_rows] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_rows][xx] = q1.x
        end
    end
    if sqlclose('q1') < 0 then call mySQLError .false
    if sqldispose('q1') < 0 then call mySQLError .false
    do i = 1 to rows~items
        say '   Determined the highest uid (hkey) in history is' rows[i]['max_key']~strip('l','0')
    end
    pull
    say '-'~copies(175)

say 'Step 20 - Disconnect from the MySQL connection'
    if sqldisconnect('c1') < 0 then call mySQLError .false
    say 'Disconnect of c1 Successful'
    if sqldisconnect('c2') < 0 then call mySQLError .false
    say 'Disconnect of c2 Successful'
exit

mySQLError: procedure expose sqlca. sigl ourname system_name
    use arg kontinue
    say
    sql_errors = .array~new
    sql_errors[sql_errors~items+1] = 'SQL Error!'
    sql_errors[sql_errors~items+1] = 'ApplicationBeingExecuted' ourname
    sql_errors[sql_errors~items+1] = 'SqlErrorOnLine' SIGL
    sql_errors[sql_errors~items+1] = 'DateOfError' date('s')
    sql_errors[sql_errors~items+1] = 'TimeOfError' time('n')
    sql_errors[sql_errors~items+1] = 'UserID' userid()
    sql_errors[sql_errors~items+1] = 'System' system_name

    do x over sqlca.
        if x~pos('.1') > 0 then iterate
        if x~translate = 'SQLERRM.1' | x~translate = 'SQLERRM' then
                parse value sqlca.x with .']'.']'.']'emsg
        else
            emsg = sqlca.x
        sql_errors[sql_errors~items+1] = x emsg
    end
    call SayErrors sql_errors
    if \kontinue then
        do
            if symbol('osql') = 'VAR' then
                osql~~rollback()~disconnect()
            say 'We Died An SQL Death'
            exit
        end
    say
return

Syntax:
    syntax_errors = .array~new
    obj = condition('o')
    rc2 = ''
    do x over obj
        select
            when x = 'RC' then rc1 = obj[x]
            when x = 'CODE' then rc2 = obj[x]
            when x = 'MESSAGE' then et2 = obj[x]
            otherwise nop
        end
    end
    syntax_errors[syntax_errors~items+1] = 'Syntax Error!'
    syntax_errors[syntax_errors~items+1] = 'ApplicationBeingExecuted' ourname
    syntax_errors[syntax_errors~items+1] = 'SyntaxErrorOnLine' SIGL
    syntax_errors[syntax_errors~items+1] = 'SourceLine' sourceline(sigl)~strip
    syntax_errors[syntax_errors~items+1] = 'Error' rc1~left(6)':' errortext(rc1)
    if rc2 \= '' then syntax_errors[syntax_errors~items+1] = 'SubError' rc2~left(6)':' et2
    syntax_errors[syntax_errors~items+1] = 'DateOfError' date('s')
    syntax_errors[syntax_errors~items+1] = 'TimeOfError' time('n')
    syntax_errors[syntax_errors~items+1] = 'UserID' userid()
    syntax_errors[syntax_errors~items+1] = 'System' system_name
    if symbol('osql') = 'VAR' then
        osql~~rollback()~disconnect()
    call SayErrors syntax_errors
    say 'We Died A Syntax Death'
exit

SayErrors: procedure
    use arg error_array
    do i = 1 to error_array~items
        say error_array[i]~word(1)~left(26,'.')':' error_array[i]~subword(2)
    end
return