/*  RxSQLWrapper.cls */
::class rxsqlwrapper public
::method rowcount attribute         -- Used to hold the rowcount
::method rows attribute             -- An array of directories of select/show results
::method details attribute          -- A directory of the contents of sqlca.
::method last_insert_id attribute   -- Used to hold the last insert id of insert statements
::method vardir attribute           -- Values of Rexx/SQL Variables

::method init
    expose connection varset
    use arg connection
    if rxfuncquery('SQLLoadFuncs') then call rxfuncadd 'SQLLoadFuncs', 'rexxsql'
    if rxfuncquery('sqlconnect') then call sqlloadfuncs
    varset = .set~of(VERSION,DEBUG,ROWLIMIT,LONGLIMIT,SAVESQL,AUTOCOMMIT,IGNORETRUNCATE, ,
                     NULLSTRINGOUT,NULLSTRINGIN,STANDARDPLACEMARKERS,SUPPORTSPLACEMARKERS, ,
                     SUPPORTSDMLROWCOUNT,SUPPORTSTHREADS,ALL)
return

::method connect
    expose connection sqlca.
    use arg dsn
    rv = sqlconnect(connection,,,, 'dsn='dsn)
    self~populatedetails()
return rv

::method disconnect
    expose connection sqlca.
    rv = sqldisconnect(connection)
    self~populatedetails()
return rv

::method query
    expose connection rowcount rows last_insert_id sqlca.
    use arg statement
    drop rowcount   -- Must have this line for multiple calls to return the correct value!
    if sqldefault(connection) < 0 then do; self~populatedetails(); return -1; end
    if sqlprepare('q1',statement) < 0 then do; self~populatedetails(); return -1; end
    if sqlopen('q1') < 0 then do; self~populatedetails(); return -1; end
    rows = .array~new()
    next_index = 0   -- in case none are fetched
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then do; self~populatedetails(); return -1; end
        if rv = 0 then leave
        next_index = rows~items+1
        rows[next_index] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_index][xx] = q1.x
        end
    end
    rowcount = next_index
    if sqlclose('q1') < 0 then do; self~populatedetails(); return -1; end
    if sqldispose('q1') < 0 then do; self~populatedetails(); return -1; end
    self~populatedetails()
return 0

::method query2
    expose connection rowcount rows last_insert_id sqlca.
    use arg statement
    drop rowcount   -- Must have this line for multiple calls to return the correct value!
    if sqldefault(connection) < 0 then do; self~populatedetails(); return -1; end
    if sqlprepare('q1',statement) < 0 then do; self~populatedetails(); return -1; end
    if sqlopen('q1') < 0 then do; self~populatedetails(); return -1; end

    rows = .array~new()
    next_index = 0   -- in case none are fetched
    do forever
         rv = sqlfetch('q1')
         if rv < 0 then do; self~populatedetails(); return -1; end
         if rv = 0 then leave
         next_index = rows~items+1
         row = .directory~new
         rows[next_index] = row
         do x over q1.
             parse lower var x xx
             row[xx] = q1.x
         end
     end

/*
    do forever
        rv = sqlfetch('q1')
        if rv < 0 then do; self~populatedetails(); return -1; end
        if rv = 0 then leave
        next_index = rows~items+1
        rows[next_index] = .directory~new
        do x over q1.
            parse lower var x xx
            rows[next_index][xx] = q1.x
        end
    end
*/

    rowcount = next_index
    if sqlclose('q1') < 0 then do; self~populatedetails(); return -1; end
    if sqldispose('q1') < 0 then do; self~populatedetails(); return -1; end
    self~populatedetails()
return 0


::method execute
    expose connection rowcount rows last_insert_id sqlca.
    use arg statement,autocommit
    drop rowcount   -- Must have this line for multiple calls to return the correct value!
    if arg(2,'o') then autocommit = .false
    if \autocommit~datatype('o') then raise syntax 34
    if sqldefault(connection) < 0 then do; self~populatedetails(); return -1; end
    if sqlprepare('e1',statement) < 0 then do; self~populatedetails(); return -1; end
    if sqlexecute('e1') < 0 then do; self~populatedetails(); return -1; end
    rowcount = sqlca.rowcount
    if statement~word(1)~translate = 'INSERT' then do
        drop last_insert_id
        rv = sqlcommand('qlid','select last_insert_id() as lid')
        last_insert_id = qlid.lid.1
    end
    if autocommit then self~commit()
    if sqldispose('e1') < 0 then do; self~populatedetails(); return -1; end
    self~populatedetails()
return 0

::method commit
    expose connection sqlca.
    if sqldefault(connection) < 0 then do; self~populatedetails(); return -1; end
    rv = sqlcommit()
    if rv \= 0 then do; self~populatedetails(); return -1; end
    self~populatedetails()
return 0

::method rollback
    expose connection sqlca.
    if sqldefault(connection) < 0 then do; self~populatedetails(); return -1; end
    rv = sqlrollback()
    if rv \= 0 then do; self~populatedetails(); return -1; end
    self~populatedetails()
return 0

::method variable
    expose connection rowcount rows last_insert_id sqlca. vardir varset
    use arg var_name,var_value
    if sqldefault(connection) < 0 then do; self~populatedetails(); return -1; end
    save_case = var_name -- return back same case as supplied
    var_name = var_name~translate
    drop vardir
    if \varset~hasindex(var_name) then
        raise syntax 40.26 array('The Variable', 1, arg(1))
    if arg(2,'e') & var_name = 'ALL' then raise syntax 93.902 array(1)
    if arg(2,'e') then do
        rv = sqlvariable(var_name,var_value)
        if rv \= 0 then do; self~populatedetails(); return -1; end
        self~populatedetails()
        return 0
    end
    vardir = .directory~new()
    if var_name = 'ALL' then do i over varset
        rv = sqlvariable(varset[i])
        vardir[varset[i]] = rv
    end
    else do
        rv = sqlvariable(var_name)
        vardir[save_case] = rv
    end
    rv = 0
    self~populatedetails()
return 0

::method populatedetails
    expose details sqlca.
    details = .directory~new()
    do x over sqlca.
        if x~pos('.') > 0 then do
            parse lower var x y '.' i
            if i \= 0 then do
                if \details~hasindex(y) then details[y] = .array~new()
                if details[y]~defaultname() = 'an Array' then details[y][i] = sqlca.x
            end
        end
        else do
            parse lower var x y
            details[y] = sqlca.x
        end
    end