/* swing_xy.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x

-- Import the required classes
    call bsf.import 'java.awt.GridLayout'       , 'GridLayout'
    call bsf.import 'java.lang.Math'            , 'Math'
    call bsf.import 'javax.swing.JButton'       , 'JButton'
    call bsf.import 'javax.swing.JComboBox'     , 'JComboBox'
    call bsf.import 'javax.swing.JFrame'        , 'JFrame'
    call bsf.import 'javax.swing.JLabel'        , 'JLabel'
    call bsf.import 'javax.swing.JTextField'    , 'JTextField'

-- Create a gridlayout
    gridlayout = .GridLayout~new
-- Set the number of columns
    gridlayout~setColumns(2)
-- Set the number of rows
    gridlayout~setRows(5)

-- Create a frame and give it a title
    frame = .JFrame~new('X/Y')
-- Get the frame's content pane
    pane = frame~getContentPane
-- Apply the gridlayout to the pane
    pane~setLayout(gridlayout)
-- Listen for CLOSE
    frame~bsf.addEventListener('window','windowClosing','.bsf~bsf.exit')

-- Create a label with a value
    ratio_label = .JLabel~new('Ratio')
-- Create a combo box
    ratio_field = .JComboBox~new
-- Add several items to the combo box
    ratio_field~~addItem('4:3')~~addItem('16:9')~~addItem('16:10')~~addItem('3:4')
-- Listen for action in the field
    ratio_field~bsf.addEventListener('action','','call CalcIt vars')
-- Listen for certain keyboard action
    ratio_field~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create a label with a value
    diagonal_label = .JLabel~new('Diagonal')
-- Create a text field
    diagonal_field = .JTextField~new
-- Listen for key action in the field
    diagonal_field~bsf.addEventListener('key','keyPressed','call CalcIt vars')
-- Listen for certain keyboard action
    diagonal_field~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create a label with a value
    x_label = .JLabel~new('X Value')
-- Create a text field
    x_field = .JTextField~new
-- Make the field non-editable
    x_field~setEditable(.false)
-- Listen for certain keyboard action
    x_field~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create a label with a value
    y_label = .JLabel~new('Y Value')
-- Create a text field
    y_field = .JTextField~new
-- Make the field non-editable
    y_field~setEditable(.false)
-- Listen for certain keyboard action
    y_field~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create a CLEAR button
    clearButton = .JButton~new('Clear')
-- Set the button's hot-key
    clearButton~setMnemonic('c')
-- Listen for action in the field
    clearButton~bsf.addEventListener('action', '', 'call Reset vars')
-- Listen for certain keyboard action
    clearButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create an EXIT button, assign hot-key, listen for events
    exitButton = .JButton~new('Exit')
    exitButton~setMnemonic('x')
    exitButton~bsf.addEventListener('action', '', '.bsf~bsf.exit')
    exitButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Add the widgets to the frame
    pane~~add(ratio_label)~~add(ratio_field)
    pane~~add(diagonal_label)~~add(diagonal_field)
    pane~~add(x_label)~~add(x_field)
    pane~~add(y_label)~~add(y_field)
    pane~~add(clearButton)~~add(exitButton)

-- Pack & show the frame
    frame~pack
    sw = frame~getToolkit~getScreenSize~getWidth
    sh = frame~getToolkit~getScreenSize~getHeight
    fw = frame~getWidth
    fh = frame~getHeight
    fx = (sw-fw)~format(,0)
    fy = 0
    frame~setLocation(fx,fy)
    frame~~show~~tofront

-- Create a directory to pass our variable to sub-routines
    vars = .directory~new
    vars~ratio_field = ratio_field
    vars~diagonal_field = diagonal_field
    vars~math_class = .Math
    vars~x_field = x_field
    vars~y_field = y_field

-- Listen for events
    do forever
        do until .nil = rexxCode
            rexxCode = bsf.pollEventText(1)
            if .nil \= rexxCode then
                do
                    if ABBREV(rexxCode, '/*BSFBEAN/*') then
                        do
                            eventInfo=bsf.getEventInfoObject(rexxCode)
                            eventObject=eventInfo[1][1]
                            select
                                when wasEscapeKeyPressed(eventObject) then call BSF 'exit'
                                otherwise nop
                            end
                        end
                    else
                        interpret rexxCode
                end
        end
    end
exit


::requires bsf.cls

::routine CalcIt
    use arg vars
    ratio_field = vars~ratio_field
    diagonal_field = vars~diagonal_field
    math_class = vars~math_class
    x_field = vars~x_field
    y_field = vars~y_field

    ratio = ratio_field~getSelectedItem
    diag = diagonal_field~getText
    dlen = diag~length

    parse var ratio denominator':'numerator

    if diag > 0 & diag~datatype('n') then
        do
            xsq=(math_class~pow(diag,2))/((1)+(math_class~pow(numerator,2))/(math_class~pow(denominator,2)))
            x = (math_class~sqrt(xsq)~format(dlen+1,2))~strip
            y = ((x * (numerator/denominator))~format(dlen+1,2))~strip
        end
    else
        do
            x = ''
            y = ''
        end

    x_field~setText(x)
    y_field~setText(y)

::routine Reset
    use arg vars
    diagonal_field = vars~diagonal_field
    x_field = vars~x_field
    y_field = vars~y_field

    x_field~setText('')
    y_field~setText('')
    diagonal_field~setText('')

::routine wasEscapeKeyPressed
    use arg eventObject
    keyCode=eventObject~keyCode
    return keyCode = 27



