/* tabbedpane2.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/

-- Define a linefeed
    lf='0a'x

-- Retrieve the instances of the colors cyan & red
    cyan = .bsf~bsf.getStaticValue('java.awt.Color','cyan')
    blue = .bsf~bsf.getStaticValue('java.awt.Color','blue')

-- Load a Java class that is embedded in another Java class
    painter1 = .bsf~new("javax.swing.text.DefaultHighlighter$DefaultHighlightPainter", cyan)

-- Need a single static value from 2 classes
    center = bsf.getStaticValue('javax.swing.JLabel','center')
    stl = bsf.getStaticValue('javax.swing.JTabbedPane','scroll_tab_layout')

-- Need several static values from this class so load them all
    ke = bsf.wrapStaticFields('java.awt.event.KeyEvent')

-- Import the required classes
    call bsf.import 'java.awt.Dimension'                    , 'Dimension'
    call bsf.import 'java.awt.GridLayout'                   , 'GridLayout'
    call bsf.import 'javax.swing.ImageIcon'                 , 'ImageIcon'
    call bsf.import 'javax.swing.JFrame'                    , 'JFrame'
    call bsf.import 'javax.swing.JLabel'                    , 'JLabel'
    call bsf.import 'javax.swing.JPanel'                    , 'JPanel'
    call bsf.import 'javax.swing.JTabbedPane'               , 'JTabbedPane'
    call bsf.import 'javax.swing.JTextArea'                 , 'JTextArea'
    call bsf.import 'javax.swing.JScrollPane'               , 'JScrollPane'

-- Define a dimension to dictate the size (all tab results will be the size of the largest)
    dimension = .Dimension~new(230,50)

-- Create a couple of ImageIcons
    icon1 = .ImageIcon~new('oorexx.gif')
    icon2 = .ImageIcon~new('rexxla.gif')

-- Create the frame and give it a name
    frame = .JFrame~new('TabbedPaneDemo')
-- What for the CLOSE button
    frame~bsf.addEventListener('window','windowClosing','.bsf~bsf.exit')

-- Define a gridlayout to use in our Panels
    glo = .GridLayout~new(1,1)

-- Create a tabbed pane
    tabbedPane = .JTabbedPane~new
-- Add an event listener to the tabbedPane
    tabbedPane~bsf.addEventListener('change', '', 'call Which_Tab')

-- Create a panel
    panel1 = .JPanel~new
-- Create a label
    filler = .JLabel~new('This is a JPanel')
-- Define the location of the label
    filler~setHorizontalAlignment(center)
-- Apply the gridlayout to the panel
    panel1~setLayout(glo)
-- Add the label to the panel
    panel1~add(filler)
-- Set the size (remember, they'll all be the size of the largest)
    panel1~setPreferredSize(dimension)
-- Add the panel to the tabbed pane
    tabbedPane~addTab('Tab 1',icon1,panel1,'Tool Tip 1')
-- Define a hot-key for the tab
    tabbedPane~setMnemonicAt(0,ke~vk_1)

-- Create a text area & add it to the tabbed pane
    tArea1 = .JTextArea~new(4,18)
-- Define some text for the text area
    text = 'This is a JTextArea That Is Editable & Has Line Wrap Set To .true.  It will only wrap lines between words.'lf''lf
    text = text'Use this as an example of a Java class embedded within another Java class.'lf''lf
    text = text'Every instance of the string "as" will be highlighted as in a multiple search.'lf''lf
-- Place 4 copies of the text in the text area
    tArea1~setText(text)
-- Turn on linewrap
    tArea1~setLineWrap(.true)
    tArea1~setWrapStyleWord(.true)
-- Get the current highlighter for the text area - to be used in highlighting matches
    hiliter = tArea1~getHighlighter
-- Define a scrollpane and add the text area to it
    sp = .JScrollPane~new(tArea1)
-- Add the scroll pane to the tabbedPane
    tabbedPane~addTab('Tab 2',.nil,sp,'Tool Tip 2')
-- Define a hot-key for this tab
    tabbedPane~setMnemonicAt(1,ke~vk_2)

-- Create another panel & add it to the tabbed pane
    panel2 = .JPanel~new
    filler = .JLabel~new('This Is Another JPanel')
    filler~setHorizontalAlignment(center)
    panel2~setLayout(glo)
    panel2~add(filler)
    tabbedPane~addTab('Tab 3',.nil,panel2,'Tool Tip 3')
    tabbedPane~setMnemonicAt(2,ke~vk_3)

-- Create another text area & add it to the tabbed pane
    tArea2 = .JTextArea~new
    tArea2~setText('This is a JTextArea That Is Not Editable')
    tArea2~setEditable(.false)
    tabbedPane~addTab('Tab 4',icon2,tArea2,'Tool Tip 4')
    tabbedPane~setMnemonicAt(3,ke~vk_4)

-- Allow tabs to be scrolled
    tabbedPane~setTabLayoutPolicy(stl)
    tabbedPane~setOpaque(.true)

-- Get the content pane of the frame and add the tabbedPane to it
    pane = frame~getContentPane
    pane~add(tabbedPane)

-- Pack the frame so we can get its width & height
    frame~pack
-- Get the screen's width & height
    sw = frame~getToolkit~getScreenSize~getWidth
    sh = frame~getToolkit~getScreenSize~getHeight
-- Get the frame's width & height
    fw = frame~getWidth
    fh = frame~getHeight
-- Calculate the x position to place our frame
    fx = (sw-fw)~format(,0)
-- Frame y position will be top of screen
    fy = 0
-- Set the location of our frame
    frame~setLocation(fx,fy)

-- Show the frame and bring it to the front
    frame~~show~~tofront

-- Watch for events
    do forever
        rexxCode = bsf.pollEventText(1)
        if .nil \= rexxCode then
            interpret rexxCode
    end
exit

Which_Tab:
    the_tab = tabbedPane~getSelectedIndex
    select
        when the_tab = 0 then
            nop
        when the_tab = 1 then
            call Search
        when the_tab = 2 then
            nop
        when the_tab = 3 then
            nop
        otherwise
            nop
    end
return

Search:
-- Clear any previous highlights
    hiliter~removeAllHighlights
    tArea1~repaint
-- Get the current document of tArea1
    doc = tArea1~getDocument
-- Get the text in the document
    text2 = doc~getText(0,doc~getLength)
-- Translate the text (in memory) to upper case for non-case sensitive search
    text2 = text2~translate
-- Define the pattern to search for and translate it to uppercase
    pattern = 'as'~translate
-- Find every instance of the pattern
    start_pos = text2~pos(pattern,1)
    do while start_pos > 0
-- Must have found a match
        end_pos = start_pos + pattern~length
-- Highlight the match (remember Java is 0 based)
        hiliter~addHighlight(start_pos-1, end_pos-1, painter1)
        tArea1~setCaretPosition(start_pos-1)

-- Find the next pattern match
        start_pos = text2~pos(pattern,end_pos)
    end
return

::requires bsf.cls

