/* swing_progressbar.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x

-- Import the required classes
    call bsf.import 'javax.swing.JButton'       , 'JButton'
    call bsf.import 'javax.swing.JFrame'        , 'JFrame'
    call bsf.import 'javax.swing.JPanel'        , 'JPanel'
    call bsf.import 'javax.swing.JProgressBar'  , 'JProgressBar'

-- Create a frame with a title
    frame = .JFrame~new('Progress Bar')
-- Create a panel
    panel = .JPanel~new
-- Create a GO button
    goButton = .JButton~new('Go')
-- Set the "hot-key" for the button
    goButton~setMnemonic('g')
-- Add a listener to the button
    goButton~bsf.addEventListener('action', '', 'call goButton')

-- Create an EXIT button, hot-key, and listener
    exitButton = .JButton~new('Exit')
    exitButton~setMnemonic('x')
    exitButton~bsf.addEventListener('action', '', '.bsf~bsf.exit')

-- Add the buttons to the panel
    panel~~add(goButton)~~add(exitButton)

-- Create a progress bar with the minimum & maximum values
    pb = .JProgressBar~new(0,500)
-- Show it, even though no progress has started
    pb~setStringPainted(.true)
-- Give the progress bar and initial text
    pb~setString('Waiting For Go')
-- Make it visible
    pb~setVisible(.true)

-- Add the progress bar to the frame
    frame~add(pb)
-- Add the panel to the frame
    frame~add(panel,'South')

-- Pack & show the frame
    frame~pack
    sw = frame~getToolkit~getScreenSize~getWidth
    sh = frame~getToolkit~getScreenSize~getHeight
    fw = frame~getWidth
    fh = frame~getHeight
    fx = (sw-fw)~format(,0)
    fy = 0
    frame~setLocation(fx,fy)
    frame~~show~~tofront

-- Listen for events
    do forever
        rexxCode = bsf.pollEventText(1)
        if .nil \= rexxCode then
            interpret rexxCode
    end
exit

goButton:
    call time('r')
    do aa = 1 to 500
        pb~setValue(aa)
        pb~setString(aa 'of' 500)
-- The next 3 lines of code will slow down the loop considerably; however, they add the
-- ability to trap events during the progress
        rexxCode = bsf.pollEventText(1)
        if .nil \= rexxCode then
            interpret rexxCode
    end
    pb~setString(time('e') 'Seconds')
return

::requires bsf.cls



