/* swing_password.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x

-- Import the required classes
    call bsf.import 'java.awt.FlowLayout'           , 'FlowLayout'
    call bsf.import 'javax.swing.JButton'           , 'JButton'
    call bsf.import 'javax.swing.JFrame'            , 'JFrame'
    call bsf.import 'javax.swing.JLabel'            , 'JLabel'
    call bsf.import 'javax.swing.JPanel'            , 'JPanel'
    call bsf.import 'javax.swing.JPasswordField'    , 'JPasswordField'

-- Create a layout for the frame
    flo = .FlowLayout~new
-- Create the frame and give it a title
    frame = .JFrame~new('Password Input')
-- Add CLOSE event listener to frame
    frame~bsf.addEventListener('window','windowClosing','.bsf~bsf.exit')
-- Get the default pane of the frame
    pane = frame~getContentPane
-- Set the pane layout
    pane~setLayout(flo)
-- Create a panel
    panel = .JPanel~new
-- Create a password field
    pwField = .JPasswordField~new(copies(' ',10))
-- Define the echo character
    pwField~setEchoChar('*')

-- Create a lable
    pwLabel = .JLabel~new('Enter The Password')

-- Create OK button
    okButton = .JButton~new('Ok')
-- Assign a "hot-key" to the button
    okButton~setMnemonic('o')
-- Add listener to button
    okButton~bsf.addEventListener('action', '', 'call okButton')

-- Create HELP button, hot-key, & listener
    helpButton = .JButton~new('Help')
    helpButton~setMnemonic('x')
    helpButton~bsf.addEventListener('action', '', 'call helpButton')

-- Add the buttons to the panel
    panel~~add(okbutton)~~add(helpButton)
-- Add the label, field, & panel to the frame
    pane~~add(pwLabel)~~add(pwField)~~add(panel)

-- Select the content of the field - prep for overwrite
    pwField~selectAll

-- Pack & show the frame
    frame~pack
    sw = frame~getToolkit~getScreenSize~getWidth
    sh = frame~getToolkit~getScreenSize~getHeight
    fw = frame~getWidth
    fh = frame~getHeight
    fx = (sw-fw)~format(,0)
    fy = 0
    frame~setLocation(fx,fy)
    frame~~show~~tofront
-- Listen for events
    do forever
        rexxCode = bsf.pollEventText(1)
        if .nil \= rexxCode then
            interpret rexxCode
    end
exit

okButton:
    pw = '01110010011001010111100001111000'
    if pwField~getText~c2x~x2b = pw then
        .bsf.dialog~messageBox('Congratulations - You Guessed The Password','Correct','information')
    else
        .bsf.dialog~messageBox('Invalid Password - Click Help','Error','error')
    pwField~setText('')
    pwField~grabFocus
return

helpButton:
    text = "You can get the password by searching"
    text = text||lf"this example's source code"
    .bsf.dialog~messageBox(text,'Help','information')
    pwField~setText('')
    pwField~grabFocus
return

::requires bsf.cls



