/* swing_menu.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what

Main:
    call SysCls
    .local~sm.what = what
    .local~sm.lf   = '0a'x
    .local~sm.tab  = '09'x
-- call the internal importClasses routine
    call importClasses

-- call the internal createAndShowGUI routine
    output = createAndShowGUI()

    do forever
        rexxCode = bsf.pollEventText(1)
        if .nil \= rexxCode then
            interpret rexxCode
    end
exit

::requires bsf.cls

::routine createAndShowGUI
    frame = .JFrame~new('Menu Demo')
    frame~bsf.addEventListener('window','windowClosing','.bsf~bsf.exit')
-- Call the internal MenuDemo class
    demo = .MenuDemo~new
    frame~setJMenuBar(demo~createMenuBar)
    frame~setContentPane(demo~createContentPane)

    frame~setSize(450,300)
    sw = frame~getToolkit~getScreenSize~getWidth
    sh = frame~getToolkit~getScreenSize~getHeight
    fw = frame~getWidth
    fh = frame~getHeight
    fx = (sw-fw)~format(,0)
    fy = 0
    frame~setLocation(fx,fy)

    frame~setVisible(.true)

return demo~output

::class MenuDemo public
::method output attribute
::method createMenuBar
    menuBar = .JMenuBar~new

-- First JMenu
    menu = .JMenu~new('A Menu')
    menu~setMnemonic('a')
    menuBar~add(menu)

-- 1st item for first JMenu
    menuItem = .JMenuItem~new('A text only menu item')
    menuItem~setMnemonic('t')
    menuItem~bsf.addEventListener('action', '', 'call ShowAction "Text only menu item",output')
    menu~add(menuItem)

-- 2nd item for first JMenu
-- Call the internal createImageIcon routine
    icon = createImageIcon('oorexx.gif')
    menuItem = .JMenuItem~new('Both text & icon',icon)
    menuItem~setMnemonic('b')
    menuItem~bsf.addEventListener('action', '', 'call ShowAction "Text & icon item",output')
    menu~add(menuItem)

-- 3rd item for first JMenu
    icon = createImageIcon('rexxla.gif')
    menuItem = .JMenuItem~new(icon)
    menuItem~setMnemonic('i')
    menuItem~bsf.addEventListener('action', '', 'call ShowAction "Icon only menu item",output')
    menu~add(menuItem)

-- Add a separator
    menu~addSeparator
-- Only one item can be selected
    group = .ButtonGroup~new

-- 4th item for first JMenu
    rbMenuItem = .JRadioButtonMenuItem~new('A radio button (1) menu item')
    rbMenuItem~setSelected(.true)
    rbMenuItem~setMnemonic('r')
    rbMenuItem~bsf.addEventListener('action', '', 'call ShowAction "Radio button 1",output')
-- 1st item in group
    group~add(rbMenuItem)
    menu~add(rbMenuItem)

-- 5th item for first JMenu
    rbMenuItem = .JRadioButtonMenuItem~new('Another radio button (2)')
    rbMenuItem~setMnemonic('o')
    rbMenuItem~bsf.addEventListener('action', '', 'call ShowAction "Radio button 2",output')
-- 2nd item in group
    group~add(rbMenuItem)
    menu~add(rbMenuItem)

-- Add a separator
    menu~addSeparator

-- 6th item in first JMenu
    cbMenuItem = .JCheckBoxMenuItem~new('A check box (1) menu item')
    cbMenuItem~setMnemonic('c')
    cbMenuItem~bsf.addEventListener('action', '', 'call ShowAction "Check box 1",output')
    menu~add(cbMenuItem)

-- 7th item in first JMenu
    cbMenuItem = .JCheckBoxMenuItem~new('Another check box (2)')
    cbMenuItem~setMnemonic('n')
    cbMenuItem~bsf.addEventListener('action', '', 'call ShowAction "Check box 2",output')
    menu~add(cbMenuItem)

-- Add a seperator
    menu~addSeparator

-- Create a sub menu (just another JMenu)
    submenu = .JMenu~new('A submenu')
    submenu~setMnemonic('s')

-- 1st item in submenu
    menuItem = .JMenuItem~new('An item in the submenu (1)')
    menuItem~bsf.addEventListener('action', '', 'call ShowAction "Submenu item 1",output')
    submenu~add(menuItem)

-- 2nd item in submenu
    menuItem = .JMenuItem~new('Another item in the submenu (2)')
    menuItem~bsf.addEventListener('action', '', 'call ShowAction "Submenu item 2",output')
    submenu~add(menuItem)

-- 8th item in first JMenu
    menu~add(submenu)

-- Create the second JMenu
    menu = .JMenu~new('Another Menu')
    menu~setMnemonic('n')

-- 1st item in second JMenu
    menuItem = .JMenuItem~new('Clear')
    menuItem~setMnemonic('c')
    menuItem~bsf.addEventListener('action', '', 'output~setText("")')
    menu~add(menuItem)

-- 2nd item in second JMenu
    menuItem = .JMenuItem~new('Exit')
    menuItem~setMnemonic('x')
    menuItem~bsf.addEventListener('action', '', '.bsf~bsf.exit')
    menu~add(menuItem)
    menuBar~add(menu)
return menuBar

::method createContentPane
    expose output
    contentPane = .JPanel~new
    contentPane~setLayout(.BorderLayout~new)
    contentPane~setOpaque(.true)

    output = .JTextArea~new(5,30)
    output~setTabSize(2)
    output~setEditable(.false)
    scrollpane = .JScrollPane~new(output)
    contentPane~add(scrollpane,'Center')
return contentPane

::routine createImageIcon
    use arg iconfile
    icon = .ImageIcon~new(iconfile)
return icon

::routine importClasses
    classes = ''
    classes = classes 'java.awt.BorderLayout'
    classes = classes 'javax.swing.JMenu'
    classes = classes 'javax.swing.JMenuItem'
	 classes = classes 'javax.swing.JCheckBoxMenuItem'
    classes = classes 'javax.swing.JRadioButtonMenuItem'
    classes = classes 'javax.swing.ButtonGroup'
    classes = classes 'javax.swing.JMenuBar'
    classes = classes 'javax.swing.ImageIcon'
    classes = classes 'javax.swing.JPanel'
    classes = classes 'javax.swing.JTextArea'
    classes = classes 'javax.swing.JScrollPane'
    classes = classes 'javax.swing.JFrame'

   do i = 1 to words(classes)
      className = classes~word(i)~substr(classes~word(i)~lastpos('.')+1)
      call bsf.import classes~word(i), className
   end
return

::routine ShowAction
    use arg action_text,output
    s = 'Action event detected.'
    s = s||.sm.lf||.sm.tab||action_text
    output~append(s||.sm.lf)
return


