/* swing_buttons1.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/

    parse source os how what
    call SysCls
    lf = '0a'x

-- Import the required classes
    call bsf.import 'java.awt.GridLayout'        , 'GridLayout'
    call bsf.import 'javax.swing.JButton'        , 'JButton'
    call bsf.import 'javax.swing.JCheckBox'      , 'JCheckBox'
    call bsf.import 'javax.swing.JFrame'         , 'JFrame'
    call bsf.import 'javax.swing.JLabel'         , 'JLabel'
    call bsf.import 'javax.swing.JRadioButton'   , 'JRadioButton'
    call bsf.import 'javax.swing.JTextField'     , 'JTextField'
    call bsf.import 'javax.swing.JToggleButton'  , 'JToggleButton'

-- Create a frame and give it a title
    frame = .JFrame~new('Swing Buttons')
-- Listen for frame CLOSE
    frame~bsf.addEventListener('window','windowClosing','call Closed')

-- Create a gridlayout of 5 rows & 2 columns
    glo = .GridLayout~new(5,2)
-- Apply the gridlayout to the frame
-- NOTE: All elements in a gridlayout are sized the same

-- Get the frame's content pane
    pane = frame~getContentPane
    pane~setLayout(glo)

-- Create a textField to display our button activity
    textField = .JTextField~new('',24)
    textField~setEditable(.false)

-- Create some JLabels to fill the second column of our grid
    label1 = .JLabel~new('JButton')
    label2 = .JLabel~new('JRadioButton')
    label3 = .JLabel~new('JToggleButton')
    label4 = .JLabel~new('JCheckBox')

-- Create an JButton with the text "OK"
    OkButton = .JButton~new('OK')
-- Assign a mnemonic (hot-key) to this button
    OkButton~setMnemonic('o')
-- Listen for its selection
    OkButton~bsf.addEventListener('action', '', 'call OKButton')
-- Listen for key events such as the ESCAPE key
    OkButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create an JRadioButton with the text "Radio Button"
    radioButton = .JRadioButton~new('Radio Button')
    radioButton~setMnemonic('r')
    radioButton~bsf.addEventListener('action', '', 'call RadioButton')
    radioButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create an JToggleButton with the text "Toggle Button"
    toggleButton = .JToggleButton~new('Toggle Button')
    toggleButton~setMnemonic('t')
    toggleButton~bsf.addEventListener('action', '', 'call ToggleButton')
    toggleButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create an JCheckBox with the text "Check Box"
    checkBox = .JCheckBox~new('Check Box')
    checkBox~setMnemonic('c')
    checkBox~bsf.addEventListener('action', '', 'call CheckBox')
    checkBox~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create an Exit button, add mnemonic, listeners
    exitButton = .JButton~new('Exit')
    exitButton~setMnemonic('x')
    exitButton~bsf.addEventListener('action', '', 'call exitButton')
    exitButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Add the labels & buttons to the frame
-- Note these will appear in the order added
    pane~~add(label1)~~add(OkButton)
    pane~~add(label2)~~add(RadioButton)
    pane~~add(label3)~~add(toggleButton)
    pane~~add(label4)~~add(checkBox)
    pane~~add(exitButton)~~add(textField)

-- Pack & show the frame
    frame~pack
    sw = frame~getToolkit~getScreenSize~getWidth
    sh = frame~getToolkit~getScreenSize~getHeight
    fw = frame~getWidth
    fh = frame~getHeight
    fx = (sw-fw)~format(,0)
    fy = 0
    frame~setLocation(fx,fy)
    frame~~show~~tofront

-- Watch for events we have added listeners for
    do forever
        do until .nil = rexxCode
            rexxCode = bsf.pollEventText(1)
            if .nil \= rexxCode then
                do
                    if ABBREV(rexxCode, '/*BSFBEAN/*') then
                        do
                            eventInfo=bsf.getEventInfoObject(rexxCode)
                            eventObject=eventInfo[1][1]
                            if wasEscapeKeyPressed(eventObject) then call Escape
                        end
                    else
                        interpret rexxCode
                end
        end
    end
exit

Escape:
    textField~setText('Escape Key Pressed')
    .bsf~bsf.exit
return

Closed:
    textField~setText('Window Closed')
    .bsf~bsf.exit
return

OKButton:
    textField~setText('OK Button Pressed')
return

RadioButton:
    textField~setText('Radio Button Selected-Current State ->' radioButton~isSelected)
return

ToggleButton:
    textField~setText('Toggle Button Selected-Current State ->' toggleButton~isSelected)
return

CheckBox:
    textField~setText('Check Box Selected-Current State ->' checkBox~isSelected)
return

ExitButton:
    textField~setText('Exit Button Pressed')
    .bsf~bsf.exit
return


::requires bsf.cls

::routine wasEscapeKeyPressed
    use arg eventObject
    keyCode=eventObject~keyCode
    return keyCode = 27



