/* elpShowSource.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
*/
    lf='0a'x

    swt        =  bsf.wrapStaticFields('org.eclipse.swt.SWT')
    call bsf.import 'org.eclipse.swt.layout.FillLayout'      , 'swtFillLayout'
    call bsf.import 'org.eclipse.swt.graphics.Color'         , 'swtColor'
    call bsf.import 'org.eclipse.swt.graphics.Font'          , 'swtFont'
    call bsf.import 'org.eclipse.swt.graphics.FontData'      , 'swtFontData'
    call bsf.import 'org.eclipse.swt.graphics.Image'         , 'swtImage'
    call bsf.import 'org.eclipse.swt.widgets.ColorDialog'    , 'swtColorDialog'
    call bsf.import 'org.eclipse.swt.widgets.Display'        , 'swtDisplay'
    call bsf.import 'org.eclipse.swt.widgets.FileDialog'     , 'swtFileDialog'
    call bsf.import 'org.eclipse.swt.widgets.FontDialog'     , 'swtFontDialog'
    call bsf.import 'org.eclipse.swt.widgets.Menu'           , 'swtMenu'
    call bsf.import 'org.eclipse.swt.widgets.MenuItem'       , 'swtMenuItem'
    call bsf.import 'org.eclipse.swt.widgets.Shell'          , 'swtShell'
    call bsf.import 'org.eclipse.swt.widgets.Text'           , 'swtText'

    display  = .swtDisplay~new
    font     = .swtFont~new(display,'Courier',10,swt~normal)

    foregroundColor = display~getSystemColor(swt~color_black)
    backgroundColor = display~getSystemColor(swt~color_white)

    shell = .swtShell~new(display)
    shell~setLayout(.swtFillLayout~new)
    shell~setText('Source Preview Screen')

    text = .swtText~new(shell,swt~border + swt~multi + swt~v_scroll + swt~h_scroll)
    text~setFont(font)
    text~setForeground(foregroundColor)
    text~setBackground(backgroundColor)

    bar = .swtMenu~new(shell,swt~bar)
    shell~setMenuBar(bar)

    fileItem = .swtMenuItem~new(bar,swt~cascade)
    fileItem~setText('File')

    submenu = .swtMenu~new(shell,swt~drop_down)
    fileItem~setMenu(submenu)

    item = .swtMenuItem~new(submenu,swt~push)
    item~bsf.addEventListener('selection','','call File')
    item~setText('Open')

    item = .swtMenuItem~new(submenu,swt~push)
    item~bsf.addEventListener('selection','','call CkSyntax')
    item~setText('Syntax')

    item = .swtMenuItem~new(submenu,swt~push)
    item~bsf.addEventListener('selection','','text~setText("");shell~setText("Source Preview Screen")')
    item~setText('Close')

    item = .swtMenuItem~new(submenu,swt~push)
    item~bsf.addEventListener('selection','','display~dispose;exit')
    item~setText('Exit')

    appearanceItem = .swtMenuItem~new(bar,swt~cascade)
    appearanceItem~setText('Appearance')

    submenu = .swtMenu~new(shell,swt~drop_down)
    appearanceItem~setMenu(submenu)

    item = .swtMenuItem~new(submenu,swt~push)
    item~bsf.addEventListener('selection','','call Font')
    item~setText('Font')

    item = .swtMenuItem~new(submenu,swt~push)
    item~bsf.addEventListener('selection','','call Foreground')
    item~setText('Foreground')

    item = .swtMenuItem~new(submenu,swt~push)
    item~bsf.addEventListener('selection','','call Background')
    item~setText('Background')

    icon = .swtImage~new(display,'rexx.jpg')
    shell~setImage(icon)

    shell~setBounds(0,340,1024,370)
    shell~open

    do while shell~isDisposed=.false
        if display~readAndDispatch then
            do
                rexxCode=bsf.pollEventText(1)
                if .nil<>rexxCode then
                   interpret rexxCode

                if \shell~isDisposed then
                    display~sleep
            end
    end
exit

File:
    dialog = .swtFileDialog~new(shell,swt~open)
    name   = dialog~open
    if .nil = name then
        shell~setText('Source Preview Screen')
    else
        do
            istream = .stream~new(name)
            iarray  = istream~arrayin
            istream~close
            ftext = ''
            ctr = 0
            do i = 1 to iarray~items
                ftext = ftext||iarray[i]
                if i < iarray~items then
                    ftext = ftext||lf
            end
            text~setText(ftext)
            shell~setText('Source Preview Screen -' name)
        end
return

Save:
    outfile = 'temp.rex'
    ostream = .stream~new(outfile)
    rv = ostream~open('replace')
    if rv = 'READY:' then
        ostream~lineout(text~getText)
    else
        .bsf.dialog~messageBox('Return Value of stream~open was' rv ,'Error','error')
    ostream~close
return

CkSyntax:
    outfile = 'temp.rex'
    rv = SysFileDelete(outfile)
    ostream = .stream~new(outfile)
    rv = ostream~open('replace')
    if rv = 'READY:' then
        do
            ostream~charout(text~getText)
            ostream~close

            'rexxc temp.rex /s 2> rexxc.txt'
            if rc \= 0 then
                do
                    output = 'rexxc.txt'
                    opstream = .stream~new(output)
                    earray = opstream~arrayin
                    opstream~close
                    errtxt = ''
                    do i = 1 to earray~items
                        errtxt = errtxt||earray[i]||lf
                    end
                    .bsf.dialog~messageBox(errtxt,'Syntax Checker','error')
                end
            else
                do
                    .bsf.dialog~messageBox('No Syntax Errors Detected','Syntax Checker','information')
                end
            rv = SysFileDelete('rexxc.txt')
        end
    else
        do
            .bsf.dialog~messageBox('Return Value of stream~open was' rv ,'Error','error')
            ostream~close
        end
return

Font:
    fontDialog = .swtFontDialog~new(shell)
    fontDialog~setFontList(font~getFontData)
    fontData   = fontDialog~open
    if .nil   \= fontdata then
        do
            font = .swtFont~new(display,fontData)
            text~setFont(font)
        end
return

Foreground:
    colorDialog = .swtColorDialog~new(shell)
    colorDialog~setRGB(foregroundColor~getRGB)
    rgb = colorDialog~open
    if .nil \= rgb then
        do
            foregroundColor = .swtColor~new(display,rgb)
            text~setForeground(foregroundColor)
        end
return

Background:
    colorDialog = .swtColorDialog~new(shell)
    colorDialog~setRGB(backgroundColor~getRGB)
    rgb = colorDialog~open
    if .nil \= rgb then
        do
            backgroundColor = .swtColor~new(display,rgb)
            text~setBackground(backgroundColor)
        end
return

SearchValue:
    string = text~getText
    sarray = string~makearray
say sarray~items  --[1]


return

::requires bsf.cls

