/* demomenu2.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10

Throughout this code sample, the Operating System value (myos) is used to determine if
certain items can be executed.  This applies to any part of this application or any application
that may get executed from this scipt that uses SWT or the Text To Speech (TTS) API.

This was NOT done because these will not work on Linux.  It was done because the author did
not have SWT nor the TTS API loaded on his Linux system.
*/
    parse source os . .

    if os~translate~pos('LINUX') > 0 then
        myos = 'l'
    else
        myos = 'w'

    .local~myos = myos

    lf='0a'x
    tab = '09'x

    if myos = 'w' then
        do
            call bsf.import 'com.sun.speech.freetts.Voice'          , 'Voice'
            call bsf.import 'com.sun.speech.freetts.VoiceManager'   , 'VoiceManager'
        end
    call bsf.import 'javax.swing.JFrame'                    , 'JFrame'
    call bsf.import 'javax.swing.JButton'                   , 'JButton'
    call bsf.import 'javax.swing.JPanel'                    , 'JPanel'
    call bsf.import 'javax.swing.JTextArea'                 , 'JTextArea'
    call bsf.import 'javax.swing.ImageIcon'                 , 'ImageIcon'
    call bsf.import 'javax.swing.ToolTipManager'            , 'ToolTipManager'
    call bsf.import 'java.awt.GridLayout'                   , 'GridLayout'

    tTM = .ToolTipManager~sharedInstance

    arial = .bsf~new('java.awt.Font','Courier',bsf.getConstant('java.awt.Font', 'BOLD'),14)
    if myos = 'w' then
        do
            voiceManager = .VoiceManager~getInstance
            helloVoice   = voiceManager~getVoice('kevin')
            helloVoice~allocate
        end

    frame = .JFrame~new('2006 RexxLA Symposium BSF4Rexx Demo Launcher 2')
    frame~bsf.addEventListener('window', 'windowClosing', '.bsf~bsf.exit')
    image = 'rexx.gif'
    icon = .ImageIcon~new(image)~getImage
    frame~setIconImage(icon)
    frameDlg=.bsf.dialog~new(frame)

    pane = frame~getContentPane
    panelN = .JPanel~new
    panelN~setToolTipText('<html>A Tooltip Can Have An Image<img src=file:'image'></html>')

    panelS = .JPanel~new
    panelS~setToolTipText('South Panel')
    panelE = .JPanel~new
    panelE~setLayout(.GridLayout~new(5,1))
    panelE~setToolTipText('East Panel')

    textArea = .JTextArea~new(10,10)
    tattt = '<html>One way to make a multi-line tooltip<br>is to use html tags with the "br" tag<br>to start a new line.</html>'
    textArea~setToolTipText(tattt)

    textArea~setEditable(.false)

    text =     'Option1'||tab||'Buttons 1'             ||tab||tab||     'swing_buttons1.rex'lf
    text = text'Option2'||tab||'Buttons 2'             ||tab||tab||     'swing_buttons2.rex'lf
    text = text'Option3'||tab||'Password Input'        ||tab||tab||     'swing_password.rex'lf
    text = text'Option4'||tab||'Progress Bar'          ||tab||tab||     'swing_progressbar.rex'lf
    text = text'Option5'||tab||'PullDown W/Key Monitor'||tab||          'swing_xy.rex'lf
    text = text'Option6'||tab||'MultInput Dialog'      ||tab||          'swing_multiinput4.rex'lf
    text = text'Option7'||tab||'Menu'                  ||tab||tab||     'swing_menu.rex'lf
    text = text'Option8'||tab||'Tabbed Pane'           ||tab||tab||     'swing_tabbedpane.rex'lf
    text = text'Option9'||tab||'Simple Window'         ||tab||          'swing_jwindow.rex'lf
    if myos = 'w' then
        do
            text = text'Print'  ||tab||'A Special Treat'       ||tab||          'swt_snippet133.rex'lf
            text = text'Source' ||tab||'Show Source Code'      ||tab||          'elpShowSource.rex (Uses SWT)'lf
        end
    text = text'Toggle' ||tab||'Toggle Tool Tips'      ||tab||          'Built Into This Menu App'lf
    if myos = 'w' then
        text = text'Speak'  ||tab||'Java TTS'              ||tab||tab||     'Built Into This Menu App'
    textArea~setFont('Arial' 10)
    textArea~setText(text)
    pane~add(textArea)

    Option1 = .JButton~new('Option1')
    Option1~setMnemonic('1')
    Option1~bsf.addEventListener('action', '', 'call demo "swing_buttons1.rex"')
    Option1~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option1~setToolTipText('swing_buttons1.rex')

    Option2 = .JButton~new('Option2')
    Option2~setMnemonic('2')
    Option2~bsf.addEventListener('action', '', 'call demo "swing_buttons2.rex"')
    Option2~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option2~setToolTipText('swing_buttons2.rex')

    Option3 = .JButton~new('Option3')
    Option3~setMnemonic('3')
    Option3~bsf.addEventListener('action', '', 'call demo "swing_password.rex"')
    Option3~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option3~setToolTipText('swing_buttons1.rex')

    Option4 = .JButton~new('Option4')
    Option4~setMnemonic('4')
    Option4~bsf.addEventListener('action', '', 'call demo "swing_progressbar.rex"')
    Option4~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option4~setToolTipText('swing_progressbar.rex')

    Option5 = .JButton~new('Option5')
    Option5~setMnemonic('5')
    Option5~bsf.addEventListener('action', '', 'call demo "swing_xy.rex"')
    Option5~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option5~setToolTipText('swing_xy.rex')

    Option6 = .JButton~new('Option6')
    Option6~setMnemonic('6')
    Option6~bsf.addEventListener('action', '', 'call demo "swing_multiinput4.rex"')
    Option6~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option6~setToolTipText('swing_multiinput4.rex')

    Option7 = .JButton~new('Option7')
    Option7~setMnemonic('7')
    Option7~bsf.addEventListener('action', '', 'call demo "swing_menu.rex"')
    Option7~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option7~setToolTipText('swing_menu.rex')

    Option8 = .JButton~new('Option8')
    Option8~setMnemonic('8')
    Option8~bsf.addEventListener('action', '', 'call demo "swing_tabbedpane.rex"')
    Option8~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option8~setToolTipText('swing_tabbedpane.rex')

    Option9 = .JButton~new('Option9')
    Option9~setMnemonic('9')
    Option9~bsf.addEventListener('action', '', 'call demo "swing_jwindow.rex"')
    Option9~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Option9~setToolTipText('swing_jwindow.rex')

    Toggle = .JButton~new('Toggle')
    Toggle~setMnemonic('t')
    Toggle~bsf.addEventListener('action', '', 'call ToggleTT vars')
    Toggle~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    Toggle~setToolTipText('ToolTipManager')

    if myos = 'w' then
        do
            Print = .JButton~new('Print')
            Print~setMnemonic('p')
            Print~bsf.addEventListener('action', '', 'call demo "swt_snippet133.rex"')
            Print~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
            Print~setToolTipText('swt_snippet133.rex')

            Source = .JButton~new('Source')
            Source~setMnemonic('s')
            Source~bsf.addEventListener('action', '', 'call demo "elpShowSource.rex"')
            Source~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
            Source~setToolTipText('elpShowSource.rex')

            Speak = .JButton~new('Speak')
            Speak~setMnemonic('k')
            Speak~bsf.addEventListener('action', '', 'helloVoice~speak("Welcome to the International Rexx Language Association Symposium")')
            Speak~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
            Speak~setToolTipText('Java FreeTTS Library')
        end
    exitButton = .JButton~new('Exit')
    exitButton~setMnemonic('x')
    exitButton~bsf.addEventListener('action', '', '.bsf~bsf.exit')
    exitButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    exitButton~setToolTipText('Exit')

    panelN~~add(Option1)~~add(Option2)~~add(Option3)~~add(Option4)~~add(Option5)
    panelS~~add(Option6)~~add(Option7)~~add(Option8)~~add(Option9)
    if myos = 'w' then
        panelE~~add(Print)~~add(Source)~~add(Toggle)~~add(Speak)~~add(exitButton)
    else
        panelE~~add(exitButton)
    frame~add(panelN,'North')
    frame~add(panelS,'South')
    frame~add(panelE,'East')

    frame~~pack~~show

    vars = .directory~new
    vars~tTM = tTM
    vars~frameDlg = frameDlg

    do forever
        do until .nil = rexxCode
            rexxCode = bsf.pollEventText(1)
            if .nil \= rexxCode then
                do
                    if ABBREV(rexxCode, '/*BSFBEAN/*') then
                        do
                            eventInfo=bsf.getEventInfoObject(rexxCode)
                            eventObject=eventInfo[1][1]
                            if wasEscapeKeyPressed(eventObject) then call BSF 'exit'
                        end
                    else
                        interpret rexxCode
                end
        end
    end
    if myos = 'w' then
        helloVoice~deallocate
exit

::requires bsf.cls

::routine wasEscapeKeyPressed
    use arg eventObject
    keyCode=eventObject~keyCode
    return keyCode = 27

::routine ToggleTT
    use arg vars
    tTM = vars~tTM
    frameDlg = vars~frameDlg
    if tTM~isEnabled then
        do
            frameDlg~messageBox('ToolTips Toggled OFF','Toggle Tool Tips','information')
            tTM~setEnabled(.false)
        end
    else
        do
            frameDlg~messageBox('ToolTips Toggled ON','Toggle Tool Tips','information')
            tTM~setEnabled(.true)
        end

::routine Demo
    parse arg prog
    if .myos = 'w' then
        'start rexxhide.exe 'prog
    else
        do
            'cd /home/lee/rfpt'
            'xterm -iconic -e rexx ./'prog
        end

