/* viewjarzipcontents.zip */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x
    call SysCls
    bsf_version = .bsf4rexx~version
-- Create a file chooser by importing the Java class
    fchooser = .bsf~new('javax.swing.JFileChooser')
-- Create a frame to place the file chooser in by importing the Java class
    frame = .bsf~new('javax.swing.JFrame','Frame')
-- Set the current directory by importing the java.io.File class (the '.' indicates the current folder)
    fchooser~setCurrentDirectory( .bsf~new("java.io.File", ".") )
-- Give our file chooser a dialog
    fchooser~setDialogTitle('Java Swing File OPEN Dialog -' bsf_version)
-- import Java class into ooRexx - the hidden Easter Egg
    call bsf.import 'org.oorexx.misc.RgfFilter', 'RgfFilter'
    filter=.rgfFilter~new('*.zip;*.jar')          -- create a new filter
    filter~setPattern(".*\.([zZ][iI][pP]|[jJ][aA][rR])$")
    fchooser~setFileFilter(filter)                -- set the filter to fileDialog
    do forever
-- Show the dialog and display back to the user their selection
        myfile = fchooser~showOpenDialog(frame)
        if myfile = 0 then
            do
                zipfile = fchooser~getSelectedFile~getPath
                zname = fchooser~getSelectedFile~getName
            end
        else
            leave
-- Create an instance of the Java class that reads a zip file
        ZFobj = .bsf~new('java.util.zip.ZipFile',zipfile)
-- Get an enumeration of the number of entries
        entries = ZFobj~entries  --
-- Gather the data on our zip/jar file
        text = ZFobj~size 'Files Found'
        height = ZFobj~size + 1
        max_width = 0
        entries=.bsf_proxy~new(bsf('wrapEnumeration', entries)) -- rgf, 2006-02-15
        do while entries~hasMoreElements
            eName = entries~nextElement~name
            if eName~length > max_width  then
                max_width = eName~length
            text = text lf||eName
        end
-- Create a JFrame instance and give it a name
        f = .bsf~new("javax.swing.JFrame","Contents of" zname bsf_version)
-- What to do if close icon on frame window is pressed
        f~bsf.addEventListener("window", "windowClosing", ".bsf~bsf.exit")
-- Create a Panel to hold our button
        p = .bsf~new("javax.swing.JPanel")
-- Import Button class
        call bsf.import "javax.swing.JButton", "javaButton"
-- Create a Close button
        closeButton=.javaButton~new("Close")
-- if button is pressed, close app
        closeButton~bsf.addEventListener("action", "", "ReDraw")
-- Add button to the panel
        p~add(closeButton)
-- Add panel to south (bottom) side of frame
        f~add(p, "South")
-- Define a text area & where to place the text in the Frame
        textArea=.bsf~new("javax.swing.JTextArea", height, max_width)
        textarea~setEditable(.false)
-- Center is .5 X & Y (relative to the position of the frame)
        f~add(textArea, "Center")
-- Set the font and size of the text
        textArea~setFont("Courier" 14)
-- Set the text & show the frame
        textArea~setText(text)
        f~pack
        sw = f~getToolkit~getScreenSize~getWidth
        sh = f~getToolkit~getScreenSize~getHeight
        fw = f~getWidth
        fh = f~getHeight
        fx = (sw-fw)~format(,0)
        fy = 0
        f~setLocation(fx,fy)
        f~~show~~tofront
        do forever
            txt = bsf("pollEventText")
            ZFobj~close
            f~dispose
            leave
        end
    end

::requires bsf.cls

