/* gregorian2.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x

-- Create The Class using the current system date/time
    gcc = bsf.import('java.util.GregorianCalendar')
-- Get an instance
    gc = gcc~getInstance

-- Gather all the static fields (constants) for our java class
    gcs = bsf.wrapStaticFields('java.util.GregorianCalendar')

-- Define a literal string of the months
    months = 'Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec'

-- Build the text string to later show in a java frame
    text = ''
    text = text||date('s') time('n')
    text = text||lf||'Note: Month is ZERO Based'
    text = text||lf

-- Gather information about the current date
    text = text||lf||'Time Zone....................:' gc~getTimeZone~getDisplayName
    text = text||lf||'Minimal Days 1st Week........:' gc~getMinimalDaysInFirstWeek
    text = text||lf||'Julian To Gregorian Date/Time:' gc~getGregorianChange~toString
    text = text||lf||'ERA..........................:' gc~get(gcs~ERA)
    text = text||lf||'YEAR.........................:' gc~get(gcs~YEAR)
    text = text||lf||'MONTH........................:' gc~get(gcs~MONTH) '-' months~word(gc~get(2)+1)
    text = text||lf||'WEEK_OF_YEAR.................:' gc~get(gcs~WEEK_OF_YEAR)
    text = text||lf||'WEEK_OF_MONTH................:' gc~get(gcs~WEEK_OF_MONTH)
    text = text||lf||'DATE.........................:' gc~get(gcs~DATE)
    text = text||lf||'DAY_OF_MONTH.................:' gc~get(gcs~DAY_OF_MONTH)
    text = text||lf||'DAY_OF_YEAR..................:' gc~get(gcs~DAY_OF_YEAR)
    text = text||lf||'DAY_OF_WEEK..................:' gc~get(gcs~DAY_OF_WEEK)
    text = text||lf||'DAY_OF_WEEK_IN_MONTH.........:' gc~get(gcs~DAY_OF_WEEK_IN_MONTH)
    text = text||lf||'AM_PM........................:' gc~get(gcs~AM_PM)
    text = text||lf||'HOUR.........................:' gc~get(gcs~HOUR)
    text = text||lf||'HOUR_OF_DAY..................:' gc~get(gcs~HOUR_OF_DAY)
    text = text||lf||'MINUTE.......................:' gc~get(gcs~MINUTE)
    text = text||lf||'SECOND.......................:' gc~get(gcs~SECOND)
    text = text||lf||'MILLISECOND..................:' gc~get(gcs~MILLISECOND)
    text = text||lf||'ZONE_OFFSET..................:' gc~get(gcs~ZONE_OFFSET)/1000/60/60 'Hours'
    text = text||lf||'DST_OFFSET...................:' gc~get(gcs~DST_OFFSET)/1000/60/60 'Hour(s)'
    text = text||lf||'Is' gc~get(1) 'A Leap Year..........:' gc~isLeapYear(gc~get(1))
    text = text||lf

-- Manipulate the date
    text = text||lf||'Set The Year To 2004 & Month to November'
-- Clear and set the year & month fields
    gc~clear(1)
    gc~set(1,2004)
    gc~clear(2)
    gc~set(2,10)

-- Another way of using static values
-- Load the static values into variable names
    YEAR = gcs~YEAR
    MONTH = gcs~MONTH
    WEEK_OF_YEAR = gcs~WEEK_OF_YEAR
    WEEK_OF_MONTH = gcs~WEEK_OF_MONTH
    DAY_OF_YEAR = gcs~DAY_OF_YEAR
    DAY_OF_WEEK = gcs~DAY_OF_WEEK
    DAY_OF_WEEK_IN_MONTH = gcs~DAY_OF_WEEK_IN_MONTH
    ZONE_OFFSET = gcs~ZONE_OFFSET
    DST_OFFSET = gcs~DST_OFFSET

-- Continue building our text string
    text = text||lf||'YEAR.........................:' gc~get(YEAR)
    text = text||lf||'MONTH........................:' gc~get(MONTH) '-' months~word(gc~get(2)+1)
    text = text||lf||'WEEK_OF_YEAR.................:' gc~get(WEEK_OF_YEAR)
    text = text||lf||'WEEK_OF_MONTH................:' gc~get(WEEK_OF_MONTH)
    text = text||lf||'DAY_OF_YEAR..................:' gc~get(DAY_OF_YEAR)
    text = text||lf||'DAY_OF_WEEK..................:' gc~get(DAY_OF_WEEK)
    text = text||lf||'DAY_OF_WEEK_IN_MONTH.........:' gc~get(DAY_OF_WEEK_IN_MONTH)
    text = text||lf||'ZONE_OFFSET..................:' gc~get(ZONE_OFFSET)/1000/60/60 'Hours'
    text = text||lf||'DST_OFFSET...................:' gc~get(DST_OFFSET)/1000/60/60 'Hour(s)'
    text = text||lf||'Is' gc~get(1) 'A Leap Year..........:' gc~isLeapYear(gc~get(1))

    text = text||lf

-- Yet another way of using static values is to research the web and find the numeric
-- value for each constant we need <http://java.sun.com/j2se/1.4.2/docs/api/constant-values.html>

-- Manipulate the time
    text = text||lf||'Add 43200 Seconds To The Time (1/2 day)'
-- Add the "Before" to our text string
    text = text||lf||'Before'
    text = text||lf||'DAY_OF_MONTH.................:' gc~get(5)
    text = text||lf||'HOUR.........................:' gc~get(10)
    text = text||lf||'HOUR_OF_DAY..................:' gc~get(11)
    text = text||lf||'MINUTE.......................:' gc~get(12)
    text = text||lf||'SECOND.......................:' gc~get(13)
    text = text||lf||'AM_PM........................:' gc~get(9)
-- Add 43,200 seconds
    gc~add(13,43200)
    text = text||lf
-- Add the "After" to our text String
    text = text||lf||'After'
    text = text||lf||'DAY_OF_MONTH.................:' gc~get(5)
    text = text||lf||'HOUR.........................:' gc~get(10)
    text = text||lf||'HOUR_OF_DAY..................:' gc~get(11)
    text = text||lf||'MINUTE.......................:' gc~get(12)
    text = text||lf||'SECOND.......................:' gc~get(13)
    text = text||lf||'AM_PM........................:' gc~get(9)

-- Determine the max value for a field
    text = text||lf
    text = text||lf||'Year Is Currently 2004 - Get Maximum Days In February'
-- Clear & set the month field
    gc~clear(2)
    gc~set(2,1)
    text = text||lf||'Maximum Days In February 04..:' gc~getActualMaximum(5)
-- Clear & set the year field
    gc~clear(1)
    gc~set(1,2006)
    text = text||lf||'Maximum Days In February 06..:' gc~getActualMaximum(5)

-- Use a common routine to display the results
    call elpFrame 'Example of the Java GregorianCalendar Class', text, 25, 70

::requires 'elpFrame.rex'

