/* fileopendialog.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x
-- Create a file chooser by importing the Java class
    fchooser = .bsf~new('javax.swing.JFileChooser')

-- Create a frame to place the file chooser in by importing the Java class
    frame = .bsf~new('javax.swing.JFrame','Frame')
-- Set the current directory by importing the java.io.File class (the '.' indicates the current folder)
    fchooser~setCurrentDirectory(.bsf~new("java.io.File", "."))
-- Give our file chooser a dialog
    fchooser~setDialogTitle('Java Swing File OPEN Dialog')
-- Show the dialog and display back to the user their selection
    myfile = fchooser~showOpenDialog(frame)
    text = 'Result Of The File OPEN Dialog'
    if myfile = 0 then
        do
            text = text||lf'Fully Qualified File =' fchooser~getSelectedFile~getPath
            text = text||lf'Just File Name       =' fchooser~getSelectedFile~getName
        end
    else
        text = text||lf'You Clicked Cancel'
    call elpFrame 'Example of the JavaX FileOpenDialog', text, 3, 74

::requires 'elpFrame.rex'

