/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
/* decimalformatter.rex */
    parse source os how what
    call SysCls
    lf = '0a'x

-- Define a linefeed
    .local~lf = lf

    numeric digits 15

    text = ''
   .local~text = text

/* Decimal Number Formatting */
    .local~text = .text||'Using DecimalFormat Class'
    dfc = bsf.import('java.text.DecimalFormat')
    df = dfc~getInstance

    var = 10193390
    call ShowIt1 var,df

    var = 10193390.00
    call ShowIt1 var,df

    var = 10193390.10
    call ShowIt1 var,df

    .local~text = .text||.lf
    .local~text = .text||.lf'Using DecimalFormat Class With "Masks/Patterns" Allows More Versitility'

    var1 = 10193390.55
    var2 = 10193390.00
    mask = '###.##'
    call ShowIt2 var1,df,mask
    call ShowIt2 var2,df,mask

    mask = '#,###.##'
    call ShowIt2 var1,df,mask
    call ShowIt2 var2,df,mask

    var1 = 12
    var2 = 12.50
    mask = '#,###.##'
    call ShowIt2 var1,df,mask
    call ShowIt2 var2,df,mask

    mask = '#,###.00'
    call ShowIt2 var1,df,mask
    call ShowIt2 var2,df,mask

    var1 = .5
    mask = '#,###.0'
    call ShowIt2 var1,df,mask

    mask = '#,###.00'
    call ShowIt2 var1,df,mask

    mask = '#,##0.00'
    call ShowIt2 var1,df,mask

    var1 = 10 / 100
    mask = '#,##0.00%'
    df~setMultiplier(100)
    call ShowIt2 var1,df,mask

    var1 = 5 / 24
    mask = "#,##0.00%"
    call ShowIt2 var1,df,mask

    var1 = 24 / 5
    mask = "#,##0.00%"
    call ShowIt2 var1,df,mask

    mask = "'$'#,##0.00"
    call ShowIt2 var1,df,mask

    var1 = 1.5
    var2 = -1.5
    mask = "+'$'#,##0.00;-'$'#,##0.00"
    call ShowIt2 var1,df,mask
    call ShowIt2 var2,df,mask

    var1 = 1.5
    var2 = -1.5
    mask = "#,##0.00' DB';#,000.00' CR'"
    call ShowIt2 var1,df,mask
    call ShowIt2 var2,df,mask

    var1 = 1020.5
    var2 = -1020.5
    mask = "0.00;'('0.00')'"
    call ShowIt2 var1,df,mask
    call ShowIt2 var2,df,mask

    call elpFrame 'Example of the Java DecimalFormat Class', .text, 28, 74

::requires 'elpFrame.rex'

::routine ShowIt1
    use arg var,df
    .local~text = .text||.lf||var~left(18) 'Formatted =' df~format(var)

::routine ShowIt2
    use arg var,df,mask
    df~applyPattern(mask)
    .local~text = .text||.lf||var~left(18) 'Formatted' mask~right(29) '=' df~format(var)

