/* ========================================================================= */
/* Template for an OODialog GUI by Jon Wolfers www.sahananda.fwbo.net/rexx   */
/* ========================================================================= */
/*                                                                           */
/* How to use this template:                                                 */
/*                                                                           */
/* This template allows you to create dialogs with OODialog without need     */
/* for the resource workshop.                                                */
/*                                                                           */
/* It sets out the class directive and the basic methods for a dialog        */
/*                                                                           */
/* OODialog is very fully featured and it would not be useful to try to      */
/* anticipate and include every possible activity.                           */
/*                                                                           */
/* Category dialogs & Property sheets subclass differently -see the Manual.  */
/*                                                                           */
/* Not all Dialogs require all the methods listed in the template.           */
/* If you are not adding any control through a particular method then you    */
/* can delete that method and let the superclass handle it                   */
/*                                                                           */
/* There is no copywrite applied to the work of preparing this template      */
/* You may copy and adapt it as you like removing whatever you like and      */
/* you are under no obligation to credit me in your work.                    */
/* At the same time, this is provided as-is and I cannot Guarantee that any  */
/* particular Dialog based on this template will work.                       */
/*                                                                           */
/* I am happy to accept corrections or suggestions for improvements          */
/*                                                                           */
/* Sahananda @ wlbc.co.uk                                    May 2005        */
/*                                                                           */
/* ========================================================================= */

signal on any name any          /* error handling if you want                */

                        /* ------------------------------------------------- */
                        /* Code that you want to execute before creating     */
                        /* the dialog goes here.                             */
                        /* ------------------------------------------------- */

MyDialog=.SympDialog~new                   /* Create OODialog Class instance */
MyDialog~UserText='Hello Symposium! - set outside class'

MyDialog~Execute('ShowTop')     /* Create, show and run the Windows Object   */

say 'Text =' MyDialog~UserText

MyDialog~DeInstall              /* Clear Up                                  */

                        /* ------------------------------------------------- */
                        /* Code that you want to execute after the Dialog    */
                        /* has been cleared goes here.                       */

exit
/* ========================================================================= */
/* Error Handling routine - returns full information to console              */
/*                                                                           */
/* All error information available is written to STDOUT (usually the console)*/
/* As this may not be present (running a GUI with REXXHIDE) a OODialog       */
/* errormessage popup is also presented                                      */
/* ========================================================================= */
any:

  signal off any

  errObj=condition("o")            /*                   get exception object */
  errObj~"_SIGL_"= SIGL            /*      add value of SIGL and  sourceline */
  errObj~"_sourceline_"= sourceline(SIGL)
  errQ=.queue~new
  Say "******************* An Error has occurred *******************"
  do err.val over errObj
     if errObj~at(err.val)~hasMethod('HasIndex')
     then do                         /* display them after the single liners */
             errq~queue(err.val~right(13,'-')||':')
             do err.line over errObj~at(err.val)
                errq~queue("             :" err.line)
             end /* DO */
             errq~queue("---")
          end /* DO */
     else say err.val~Right(13)||':['errObj~at(err.val)||']'
  end

  do while errq~items>0
     say errq~pull
  end /* DO */

  Say "****************** End of error diagnostics ***************"
                         /* in case there is no console - show error message */

  call errormessage 'Error' errObj~rc errObj~errortext '0a'x ,
                    'occurred on line' errObj~_sigl_ 'of' ,
                     errObj~program '0a'x ,
                     errObj~Message '0a'x

exit -1
/* ========================================================================= */
::requires 'oodwin32.cls'
::requires 'dlgarea.cls'     -- Uncomment if you use DlgArea or DlgAreaU
/* ========================================================================= */
::class SympDialog subclass userdialog inherit AdvancedControls MessageExtensions
/* ------------------------------------------------------------------------- */
::method Init
/* ------------------------------------------------------------------------- */
  self~Init:super               /* we call the Super Class (userdialog)      */
  width=455 ; height=220        /* Set the Width and height of dialog        */

                                /* Now we create the Windows Object          */
  rc=self~CreateCenter(width,height,'Demo Dialog',,,'MS Sans Serif',8)

  self~InitCode=(rc=0)


/* ------------------------------------------------------------------------- */
::method DefineDialog
/* ------------------------------------------------------------------------- */
/* This is where we lay out the controls (widgets) in our dialog             */
/* Refer to the OODialog manual for the Add methods and their parameters     */
/* ------------------------------------------------------------------------- */
u = .dlgAreaU~new(self) -- Whole dialog
e = .dlgArea~new(u~x('')   ,u~y('')   ,u~w('80%'),u~h('90%'))
b = .dlgArea~new(u~x('80%'),u~y('')   ,u~w('r')  ,u~h('90%'))
s = .dlgArea~new(u~x('')   ,u~y('90%'),u~w('')   ,u~h('r')  )

self~AddEntryLine(10,'userText',e~x,e~y,e~cx,e~cy,'multiline')
self~addText(s~x,s~y,s~cx,s~cy,'Status info appears here','center',11)

do i = 1 to 6
   self~addButton(11+i,b~x,b~y(((i-1)*10)||'%'),b~cx,b~cy('9%'),'Button' i,,
                  'Button' i)
end /* DO */

self~AddButton( 1,b~x,b~y(-15),b~w,15,'OK','Ok','DEFAULT')

/* ------------------------------------------------------------------------- */
::method UnKnown
/* ------------------------------------------------------------------------- */
use arg msg,parms

statusLine = self~GetStaticControl(11)
statusLine~SetTitle('You pressed' msg)

