/* ------------------------------------------------------------------------- */
/* ConnectRadioGroup.Rex   Sahananda  March 2006                             */
/*                                                                           */
/* This script demonstrates how to subclass the GetData & SetData methods of */
/* the UserDialog Class to connect a radio group to an attribute             */
/*                                                                           */
/* ------------------------------------------------------------------------- */

dlg=.ChkBoxDlg~new
dlg~Colour='Yellow'   /* <<< Choose which radio button is selected initially */
dlg~execute('showtop')
dlg~deinstall
                    /* <<< Return radio button selected at dialog completion */
say 'Colour selected=' dlg~colour

::requires 'oodwin32.cls'
/* ========================================================================= */
::class ChkBoxDlg SubClass UserDialog
::method init
/* ------------------------------------------------------------------------- */

self~init:super
rc = self~createCenter(62,120,'Select a Colour')
self~initCode=(rc=0)

/* ------------------------------------------------------------------------- */
::method defineDialog
/* ------------------------------------------------------------------------- */
expose ColourArr  /* colourArr contains values associated with radio buttons */

colourArr=.Array~of('Red','Yellow','Green','Purple','White','Black')
self~addRadioGroup(10,10,10,,ColourArr~makeString~changeStr('0d0a'x,' '))

self~addButton(1,10,100,42,15,'OK','Ok','default')

/* ------------------------------------------------------------------------- */
::method colour attribute
/* ------------------------------------------------------------------------- */
::method setData
/* ------------------------------------------------------------------------- */
/* subclass of UserDialog setData method.                                    */
/* We add a call to setRadioAttribute for each radio group we want to connect*/
expose colourArr
self~setData:super

self~setRadioAttribute('colour',colourArr,10)
/* ------------------------------------------------------------------------- */
::method getData
/* ------------------------------------------------------------------------- */
/* subclass of UserDialog getData method.                                    */
/* We add a call to getRadioAttribute for each radio group we want to connect*/
expose colourArr
self~getData:Super

self~getRadioAttribute('colour',colourArr,10)

/* ------------------------------------------------------------------------- */
::method getRadioAttribute
/* ------------------------------------------------------------------------- */
/* Parameters                                                                */
/*    attName      Name of the Attribute to connect - you must create this   */
/*    Arr          Array of values to associate with radio check boxes       */
/*    StartId      Id of first Radio Button as declared in DefineDialog      */
/*                                                                           */
/* This method sets the attribute passed to the value in the passed array    */
/* that coresponds to the checked control in the radio group (if any)        */
/*                                                                           */
/* ------------------------------------------------------------------------- */
use arg attName,arr,startId

interpret 'self~'||attname||'=""'
do i = 1 to arr~items
   if self~getCheckBox(i + startId - 1)
   then interpret 'self~'||attName||'= self~'||attName||' Arr['i']'
end /* DO */

interpret 'attBlank=(self~'||attName||'="")'
if \attBlank
then interpret 'self~'||attName||'=self~'||attName||'~substr(2)'

/* ------------------------------------------------------------------------- */
::method setRadioAttribute
/* ------------------------------------------------------------------------- */
/* Parameters                                                                */
/*    attName      Name of the Attribute to connect - you must create this   */
/*    arr          Array of values to associate with radio check boxes       */
/*    startId      Id of first Radio Button as declared in DefineDialog      */
/*                                                                           */
/* This method sets the check boxes whose text in the passed array are       */
/* found in the passed attribute                                             */
/*                                                                           */
/* ------------------------------------------------------------------------- */
use arg attName,arr,startId

interpret 'attText=self~'||attName

do i = 1 to arr~items
   if attText~wordpos(arr[i]) > 0
   then self~setCheckBox(i + startId - 1,1)
end /* DO */

