/* ========================================================================= */
/* ContextMenuDemo   -   Sahananda   -   April 2006                          */
/* This script demonstrates the nearest to a windows-style context-menu      */
/* that I can get out of OODialog                                            */
/* ========================================================================= */

dlg=.rclick~new
dlg~execute
dlg~deInstall

exit

::requires 'oodwin32.cls'
::requires 'dlgarea.cls'
/* ========================================================================= */
::class rclick Subclass UserDialog inherit advancedcontrols messageExtensions
/* ========================================================================= */
::method init
/* ------------------------------------------------------------------------- */
  self~Init:super
  width=150 ; height=70         /* Set the Width and height of dialog        */

                                /* Now we create the Windows Object          */
  rc=self~CreateCenter(width,height,'Right Click a colour',,,,
                                    'MS Sans Serif',12)
  self~InitCode=(rc=0)
  self~ConnectCommonNotify(10,'rclick','onRClick')

/* ------------------------------------------------------------------------- */
::method DefineDialog
/* ------------------------------------------------------------------------- */
u=.DlgAreaU~new(self)
l=.dlgArea~new(u~x,u~y,u~w,u~h('80%'))
b=.dlgarea~new(u~x,u~y('80%'),u~w,u~hr,0)
self~AddListControl(10,'colorNo',l~x,l~y,l~w,l~h,'list')
self~AddButton(1,b~x,b~y,b~w('30%'),b~h,'Leave',OK,'default')
self~AddText(b~x('30%'),b~y,b~wr,b~h,' ','center',11)

/* ------------------------------------------------------------------------- */
::method initdialog
/* ------------------------------------------------------------------------- */
self~initdialog:super

list=self~GetListControl(10)
if list \=.nil
then list~~add('red'),
         ~~add('blue'),
         ~~add('orange'),
         ~~add('green'),
         ~~add('purple'),
         ~~add('mauve'),
         ~~add('pink'),
         ~~add('white'),
         ~~add('black')

/* ------------------------------------------------------------------------- */
::method onRClick
/* ------------------------------------------------------------------------- */
use arg id

list=self~GetListControl(id)

self~GetData
picked = list~itemText(self~colorNo)

ContextArr = .array~of('paint the town %',,
                       'paint the wall %',,
                       'order % wine',,
                       '% is my favourite colour',,
                       'do something % today',,
                       '% % oh %')

ContMenu = .ContextMenu~new(picked,ContextArr,self~FactorX,Self~FactorY),
           ~~execute('showtop'),
           ~~deInstall

self~GetStaticControl(11)~~SetTitle(contMenu~selected)     /* display choice */

/* ========================================================================= */
::class ContextMenu SubClass UserDialog inherit AdvancedControls MessageExtensions
/* ========================================================================= */
::method init
/* parms                                                                     */
/*    term  - replaceable parameter                                          */
/*    texts - array of texts for menu                                        */
/*        % = replace with term                                              */
/* ------------------------------------------------------------------------- */
expose texts width height
use arg term,texts,FactorX,FactorY

  parse value self~CursorPos with mouseX MouseY .

  maxtermlength = 0
  do i = 1 to texts~items
     texts[i]=texts[i]~changestr('%',term)
     maxtermLength=max(maxtermlength,texts[i]~length)
  end /* DO */

  self~Init:super
  width=trunc(maxTermLength * 4.4) ; height=(texts~items * 10)

                                /* Now we create the Windows Object          */
  rc=self~Create((mouseX - (width/2))  / FactorX,,
                 (MouseY)              / FactorY,,
                 width,height,,
                 'Choose','nomenu',,'Courier',8)
  self~InitCode=(rc=0)
  self~Selected=''                    /* default to return if escape pressed */
  self~ConnectListBoxNotify(10,'SelChange','ok')

/* ------------------------------------------------------------------------- */
::method defineDialog
/* ------------------------------------------------------------------------- */
expose width height
self~AddListBox(10,'Selected',0,0,width,height,'notify noborder')

/* ------------------------------------------------------------------------- */
::method InitDialog
/* ------------------------------------------------------------------------- */
expose texts

self~initDialog:Super

l = self~GetListBox(10)

if l \= .nil
then do text over texts
   l~add(text)
end /* DO */

