/* ex_stem.rex: demoing USE ARG, ---rgf: 2005-04-17  */

info.1 = "Hi, I am a stem which could not get altered in a procedure!"
info.0 = 1              /* indicate one element in stem                         */
call work info.         /* call procedure which adds another element (entry)    */
do i=1 to info.0        /* loop over stem                                       */
   say info.i           /* show content of stem.i                               */
end
exit

work: procedure
   use arg great.       /* note the usage of "USE ARG" instead of "PARSE ARG"   */
   idx = great.0 + 1    /* get number of elements in stem, enlarge it by 1      */
   great.idx = "Object Rexx allows to directly access and manipulate a stem!"
   great.0 = idx        /* indicate new number of elements in stem              */
   return

/* yields:

   Hi, I am a stem which could not get altered in a procedure!
   Object Rexx allows to directly access and manipulate a stem!
*/
