/*
	program: rgf_oleinfo2html.rex
	type:    Object Rexx for Windows
	purpose: Query the OLE/ActiveX automation interface, create HTML renderings of results
	
	version: 1.00.1
	date:
            2003-03-23, ---rgf, corrected a bug (alert addressed, even if called from commandline)
            2003-01-03, ---rgf, released
            2002-06-12, ---rgf, begin
            2002-08-07, ---rgf, allow an optional 4th argument
            2002-12-29, ---rgf, use MutableBuffer to speed up creation of HTML (22 times!)
            2003-01-03, ---rgf, cleaned up the code a little bit
	
	author:  Rony G. Flatscher,
				Wirtschaftsuniversitaet/Vienna
				http://www.wu-wien.ac.at
				Rony.Flatscher@wu-wien.ac.at
	
	needs:	rgf_oleinfo.cls, at least Object Rexx 2.1.2 (avaiable since 2002-12-02)
	
	usage:   require this file
	
				rgf_oleinfo(app_name[, [oleobj] [, [bCompact] [, HTMLString]]] )
				
				app_name		OLE/ActiveX program name or class-id
				oleobj		OLE object, .nil or empty string
								... if .nil or empty string, an OLE object is created with app_name
				bCompact    ... .true=compact rendering, .false=full rendering including constants
            HTMLString  ... if given, gets inserted right before tables begin
				
	returns: array with two elements: string of <head> and string of <body>				
*/

nl="0d0a"x

   -- create a stylesheet link with a fully quailified name in addition to one without a path
stylesheet="rgf_oleinfo.css"
tmp=stream(stylesheet, "c", "query exists")

if tmp="" then    -- hmm, not found, maybe wer are not in our home directory, try it with that
do
   parse source . . full_path       -- get fully qualified name of this program
   tmp=stream(filespec("d", full_path) || filespec("p", full_path) || stylesheet, "c", "query exists")
   -- tmp9="tmp1="tmp1 nl " tmp="tmp
   if window <> "WINDOW" then call alert tmp
                         else .error~say(tmp)
end

if tmp <> "" then tmp='<link rel="stylesheet" type="text/css" href="'||changestr("\", tmp, "/")||'" id="rgf_css2">    '
             else tmp=""

	-- HTML head text								
.local~head.text = 									                                             ,
			'<head>                                                                         'nl ,
			'<!-- Rony G. Flatscher, Wirtschaftsuniversitaet Wien, Austria, Europe 2002     'nl ,
			'                        http://www.wu-wien.ac.at, version 2002.12.29        --> 'nl ,
			'                                                                               'nl ,
			'<meta name="author"   content="Rony G. Flatscher">                             'nl ,
			'<meta name="keywords" content="\\//, OLE, ActiveX, interfaces, HTML, listing,  'nl ,
			'										Rexx, Object Rexx">                               'nl ,
			'<title>OLE/ActiveX Automation Interfaces for "\\//" </title>                   'nl ,
			'<link rel="stylesheet" type="text/css" href="rgf_oleinfo.css" id="rgf_css">    'nl ,
         nl ,
         '              <!-- just to make sure that an absolute path exists also: -->    'nl ,
         tmp nl ,
			'                                                                               'nl ,
			'</head>                                                                        'nl ,
			'<body>                                                                         'nl ,
			'<div id="root">                                                                'nl

	-- HTML body text leadin
.local~leadin.body.text  = '<body><div id="root">                                        'nl

	-- HTML body text leadout
.local~leadout.body.text = '</div></body>                                                'nl
			

   -- flip-code
.local ~ flip.code =                                                                      nl ,
			'                                                                               'nl ,
  			'<script language="Object Rexx">                                                'nl ,
  			'	-- displays/hides thead, tbody, makes sure checkbox is appropriately checked 'nl ,
  			'	::routine flip public                                                        'nl ,
  			'	  use arg base_id				-- basename of the id-values needed in here       'nl ,
  			'                                                                               'nl ,
  			'	 all	= document~all				-- get collection of all available objects	  'nl ,
  			'	 th		= all~at( base_id || 1 )	-- get table-head-object                 'nl ,
  			'	 tbody	= all~at( base_id || 2 )	-- get table-body                        'nl ,
  			'	 cb		= all~at( "CB_" || base_id ) 	-- get appropriate checkbox object    'nl ,
  			'	                                                                             'nl ,
  			'	 if th~style~display="none" then                                             'nl ,
  			'	 do                                                                          'nl ,
  			'		th~style~display=""			-- display again                               'nl ,
  			'		tbody~style~display=""		-- display again                               'nl ,
  			'		cb~checked=.true			-- just make sure that checkbox is checked        'nl ,
  			'	 end                                                                         'nl ,
  			'	 else                                                                        'nl ,
  			'	 do                                                                          'nl ,
  			'		th~style~display="none"		-- display again                               'nl ,
  			'		tbody~style~display="none"	-- display again                               'nl ,
  			'		cb~checked=.false			-- just make sure that checkbox is not checked    'nl ,
  			'	 end                                                                         'nl ,
  			'	 return                                                                      'nl ,
  			'</script>                                                                      'nl
			

      -- query computer, domain and user-name, save info with the local environment for later referral
if .rgf.info=".RGF.INFO" then -- not set yet, query WSH for user data
do
	wn = .OLEObject~New("WScript.Network")
	.local~rgf.info = wn~userName"/"wn~userDomain"@\\"wn~computerName
end


::requires "rgf_oleinfo.cls"		-- class which queries and keeps the OLE-infos

	/* create the HTML rendered output of the ole-infos	*/									
::routine oleinfo2html	public
  use arg olestring, oleobj, bCompact, htmlString

  bCompact = (bCompact=.true)	-- default to .false, i.e. more verbose output
  bBrowser = (window<>"WINDOW")	-- determine whether running under MS Internet Explorer
  if bBrowser then	-- assuming to run under WWW-browser						
	  window~status='Interrogating the OLE object automation interface ...'

  if arg(2)="" | arg(2)=.nil then a=.rgf.oleinfo~new(.nil, olestring)   -- create a parsed OLEObject object
                             else a=.rgf.oleinfo~new(oleobj, olestring)

  if a~oleobject=.nil then return .array~new  -- no OLEObject available, return empty array

  ts. = a~allMethodSortedStem	-- stem with all methods sorted

--  outArray = .array~new			-- create array which contains the HTML-lines
--  aIdx     = 1						-- set array index to 1

  outMB=.mutableBuffer~new
  -- call time "r"

  call sag '<h1 class="hilite">' a~oleString '</h1>'
  call sag
  call sag 'Definitions from typelib:' '[<span class="doc hilite">'a~libname'</span>]'
  call sag 'with the brief documentation:'
  call sag '[<span class="doc hilite">'a~libdoc'</span>]'
  call sag

  if arg(4, "Exists") then call sag htmlString  -- insert received HTML-string

  if bCompact then call do_the_work_compact
				  else
              do
                 call sag .flip.code      -- add flip-code for showing/hiding table bodies
                 call do_the_work
              end

  call sag '<p>'
  call sag '<div class="bottom_info">'
  call sag '<hr>'
  call sag 'Created with <span class="hilite">'
  call sag '<a href="http://www.software.ibm.com/ad/obj-rexx/">Object</a>'
  call sag '<strong><a href="http://www.RexxLA.org">Rexx</a></strong> </span> (&quot;rgf_oleinfo_html.rex&quot;)'
  call sag 'on' '<span class="hilite">' pp(date("s") time()) '</span>'
  call sag 'run by' '<span class="hilite">' pp(.rgf.info) '</span>'
  call sag '<hr>'
  call sag '</div>'

  call sag

  tmp=outMB~string

  -- broken up into two pieces: a string for <head> and one for <body>
  return .array~of( changestr( "\\//", .head.text, olestring), .leadin.body.text tmp .leadout.body.text )


	/* create the HTML text for documenting the OLE interfaces: methods, get/put properties, events, constants */
do_the_work:

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* dump methods	*/
					
  call sag '<p>'

  o=a~methodDir		-- get method directory from OLEInfo object
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'methods ...'
	
  call sag
  call sag '<table id="meth0" border width="100%" cellpadding="3" class="main_table">'
  -- call sag '<table id="meth0" width="100%" class="main_table">'

  if o~items=0 then
  do
     tmp1=''
     tmp2='style="display:none"'
  end
  else
  do
     tmp1='checked'
     tmp2=''
  end

  call sag
  call sag '<tr><th width="10%" onclick="call flip ''meth''" language="Object Rexx">show',
               '<input type="CHECKBOX"' tmp1 'id="CB_meth">'
					
  call sag '<th colspan="2" class="caption">' '<span class="hilite">' a~methodDir~items  'Method[s]'  '</span>'
  call sag '<tr id="meth1"' tmp2'><th>No. <th>Name <th>Documentation, Argument[s], Return Value'
  call sag '<col align="right" class="number"> <col class="name"> <col>'
  call sag '<tbody id="meth2"' tmp2'>'
  call sag

  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'methods ...'

  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
        call sag '<tr class="' || choose(m//2, "odd", "even") || '"><td>'m '<td>' ts.i ,
		         '<td> <span class="doc">' ot~doc~string '</span>' '<br>'

      call sag
		call sag '<table>'
		if ot~params~items > 0 then
		do
			call sag '<tr> <td align="right">arg: <td>'
			call write_arguments ot~params
		end
        call sag '<tr class="return"><td align="right">returns: <td class="type">' ot~retType choose(ot~retType="VT_VOID", "( no return value )", "")
		call sag '</table>'
     end
     call sag
  end
  call sag '</tbody>'
  call sag '</table>'
  call sag

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* readonly properties	*/
  call sag '<p>'

  o=a~getOnlyPropertyDir	-- get directory with the read-only properties from OLEinfo object
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'read-only properties ...'

				
  call sag
  call sag '<table id="getOnly0" border width="100%" cellpadding="3" class="main_table">'

  if o~items=0 then
  do
     tmp1=''
     tmp2='style="display:none"'
  end
  else
  do
     tmp1='checked'
     tmp2=''
  end

  call sag '<tr><th width="10%" onclick="call flip ''getOnly''" language="Object Rexx">show',
               '<input type="CHECKBOX"' tmp1 'id="CB_getOnly">'
			
  call sag '<th colspan="2" class="caption">' '<span class="hilite">'  a~getOnlyPropertyDir~items 'Read-only Properties' '</span>'

  call sag '<tr id="getOnly1"' tmp2'><th>No. <th>Name <th>Documentation, Return Value'
  call sag '<col align="right" class="number"> <col class="name"> <col>'
  call sag
  call sag '<tbody id="getOnly2"' tmp2'>'

  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
        -- call sag '<tr><td>'m '<td>' ts.i '<td> <span class="doc">' ot~doc~string '</span>' '<br>'
		
        call sag '<tr class="' || choose(m//2, "odd", "even") || '"><td>'m '<td>' ts.i ,
		         '<td> <span class="doc">' ot~doc~string '</span>' '<br>'

					
      call sag
		call sag '<table>'
		if ot~params~items > 0 then
		do
			call sag '<tr> <td align="right">arg: <td>'
			call write_arguments ot~params
		end
        call sag '<tr class="return"><td align="right">returns: <td class="type">' ot~retType choose(ot~retType="VT_VOID", "( no return value )", "")
		
		call sag '</table>'
      call sag
     end
  end
  call sag '</tbody>'
  call sag '</table>'
  call sag

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* write-only properties	*/
  call sag '<p>'

  o=a~putOnlyPropertyDir	-- get write-only property from OLEinfo object
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'write-only properties ...'

  call sag
  call sag '<table id="putOnly0" border width="100%" cellpadding="3" class="main_table">'

  if o~items=0 then
  do
     tmp1=''
     tmp2='style="display:none"'
  end
  else
  do
     tmp1='checked'
     tmp2=''
  end

  call sag '<tr><th width="10%" onclick="call flip ''putOnly''" language="Object Rexx">show',
               '<input type="CHECKBOX"' tmp1 'id="CB_putOnly">'
					
  call sag '<th colspan="2" class="caption">' '<span class="hilite">'  a~putOnlyPropertyDir~items 'Write-only Properties' '</span>'

  call sag '<tr id="putOnly1"' tmp2'><th>No. <th>Name <th>Documentation, Argument[s], Return Value'
  call sag '<col align="right" class="number"> <col class="name"> <col>'
  call sag
  call sag '<tbody id="putOnly2"' tmp2'>'

  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
        -- call sag '<tr><td>'m '<td>' ts.i '<td> <span class="doc">' ot~doc~string '</span>' '<br>'
		
        call sag '<tr class="' || choose(m//2, "odd", "even") || '"><td>'m '<td>' ts.i ,
		         '<td> <span class="doc">' ot~doc~string '</span>' '<br>'

					
      call sag
		call sag '<table>'
		if ot~params~items > 0 then
		do
			call sag '<tr> <td align="right">arg: <td>'
			call write_arguments ot~params
		end
        call sag '<tr class="return"><td align="right">returns: <td class="type">' ot~retType choose(ot~retType="VT_VOID", "( no return value )", "")
		call sag '</table>'
     end
     call sag
  end
  call sag '</tbody>'
  call sag '</table>'

  call sag


  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* read/write properties	*/
  call sag '<p>'
  o=a~getAndPutPropertyDir
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'read/write properties ...'

  call sag
  call sag '<table id="getAndPut0" border width="100%" cellpadding="3" class="main_table">'

  if o~items=0 then
  do
     tmp1=''
     tmp2='style="display:none"'
  end
  else
  do
     tmp1='checked'
     tmp2=''
  end

  call sag '<tr><th width="10%" onclick="call flip ''getAndPut''" language="Object Rexx">show',
               '<input type="CHECKBOX"' tmp1 'id="CB_getAndPut">'
					
  call sag '<th colspan="2" class="caption">' '<span class="hilite">'  a~getAndPutPropertyDir~items 'Read/Write Properties' '</span>'

  call sag '<tr id="getAndPut1"' tmp2'><th>No. <th>Name <th>Documentation, Argument[s], Return Value'
  call sag '<col align="right" class="number"> <col class="name"> <col>'
  call sag
  call sag '<tbody id="getAndPut2"' tmp2'>'

  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
        -- call sag '<tr><td>'m '<td>' ts.i '<td> <span class="doc">' ot~doc~string'</span>'  '<br>'
		
        call sag '<tr class="' || choose(m//2, "odd", "even") || '"><td>'m '<td>' ts.i ,
		         '<td> <span class="doc">' ot~doc~string '</span>' '<br>'

      call sag
		call sag '<table>'
		if ot~params~items > 0 then
		do
			call sag '<tr> <td align="right">arg: <td>'
			call write_arguments ot~params
		end
        call sag '<tr class="return"><td align="right">needs/returns: <td class="type">' ot~retType choose(ot~retType="VT_VOID", "( no return value )", "")
		call sag '</table>'
      call sag
     end
  end
  call sag '</tbody>'
  call sag '</table>'
  call sag



  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* unknown properties/methods, i.e. unknown invocation type */
  call sag '<p>'
  o=a~naDir
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'unknown invocation types ...'
	
  call sag
  call sag '<table id="unknownMeth0" border width="100%" cellpadding="3" class="main_table">'

  if o~items=0 then
  do
     tmp1=''
     tmp2='style="display:none"'
  end
  else
  do
     tmp1='checked'
     tmp2=''
  end

  call sag '<tr><th width="10%" onclick="call flip ''unknownMeth''" language="Object Rexx">show',
               '<input type="CHECKBOX"' tmp1 'id="CB_unknownMeth">'
					
  call sag '<th colspan="2" class="caption">' '<span class="hilite">'  a~naDir~items 'Methods with Unknown Invocation Type Properties' '</span>'

  call sag '<tr id="unknownMeth1"' tmp2'><th>No. <th>Name <th>Documentation, Argument[s], Return Value'
  call sag '<col align="right" class="number"> <col class="name"> <col>'
  call sag
  call sag '<tbody id="unknownMeth2"' tmp2'>'

  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
        -- call sag '<tr><td>'m '<td>' ts.i '<td> <span class="doc"' ot~doc~string '</span>' '<br>'
        call sag '<tr class="' || choose(m//2, "odd", "even") || '"><td>'m '<td>' ts.i ,
		         '<td> <span class="doc">' ot~doc~string '</span>' '<br>'

        call sag 'Invocation type:' ot~invkind  "(".rgf.invKind[ot~invkind]")" '<br>'
		
        call sag
        call sag '<table>'
		
        if ot~params~items > 0 then
        do
        	call sag '<tr> <td align="right">arg: <td>'
        	call write_arguments ot~params
        end
		
        call sag '<tr class="return"><td align="right">returns: <td class="type">' ot~retType choose(ot~retType="VT_VOID", "( no return value )", "")
		  call sag '</table>'
        call sag '<br>'
     end
     call sag
  end
  call sag '</tbody>'
  call sag '</table>'
  call sag


  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* events */
  call sag '<p>'
  o=a~eventDir
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'events ...'

  call sag
  call sag '<table id="events0" border width="100%" cellpadding="3" class="main_table">'

  if o~items=0 then
  do
     tmp1=''
     tmp2='style="display:none"'
  end
  else
  do
     tmp1='checked'
     tmp2=''
  end

  call sag '<tr><th width="10%" onclick="call flip ''events''" language="Object Rexx">show',
               '<input type="CHECKBOX"' tmp1 'id="CB_events">'

  call sag '<th colspan="2" class="caption">' '<span class="hilite">'  a~eventDir~items 'Event(s)' '</span>'

  call sag '<tr id="events1"' tmp2'><th>No. <th>Name <th>Documentation, Argument[s], Return Value'
  call sag '<col align="right" class="number"> <col class="name"> <col>'
  call sag
  call sag '<tbody id="events2"' tmp2'>'

  ts. = a~eventSortedStem

  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
        call sag '<tr class="' || choose(m//2, "odd", "even") || '"><td>'m '<td>' ts.i ,
		         '<td> <span class="doc">' ot~doc~string '</span>' '<br>'

        if ot~params~items > 0 then
        do
			
           call sag
           call sag '<table>'
           call sag '<tr> <td align="right">arg: <td>'
           call write_arguments ot~params
           call sag '</table>'
        end
        else call sag '&nbsp;'
        call sag
     end
  end
  call sag "</tbody>"
  call sag '</table>'
  call sag



  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  /* constants	*/
  ts.=a~constantSortedStem

  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' ts.0 'constants ...'
	
  call sag '<p>'
  call sag
  call sag '<table id="constants0" border width="60%" cellpadding="3" class="main_table">'
  call sag '<tr><th width="17%" onclick="call flip ''constants''" language="Object Rexx">show',
               '<input type="CHECKBOX" id="CB_constants">'

  call sag '<th colspan="2" class="caption">' '<span class="hilite">'  ts.0 'Constant(s)' '</span>'

  tmp2='style="display:none"'								
  call sag '<tr id="constants1"' tmp2'><th>No. <th>Name <th>Value'
  call sag '<col align="right" class="number"> <col> <col align="right" class="number">'
  call sag
  call sag '<tbody id="constants2"' tmp2'>'


  do i=1 to ts.0
     call sag '<tr class="' || choose(i//2, "odd", "even") || '"><td>'i '<td>' ts.i '<td>' a~oleobject~getconstant( ts.i )
  end
  call sag "</tbody>"
  call sag "</table>"
  call sag
   		

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  call sag
  		
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Done.'
  return


						
	/* create a compact (terse) output: methods, properties, events */							
do_the_work_compact:
	/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

  call sag '<p>'

  o=a~methodDir
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'methods ...'

  call sag
  call sag '<table id="meth0" cellspacing="0" width="100%" class="compact_table">'

  call sag '   <th colspan="4" class="caption">' '<span class="hilite">' a~methodDir~items  'Method[s]'  '</span>'

  call sag '<tr id="meth1"><th align="right">No. <th align="right">  <th align="left">Name'
  call sag '   <th align="left">Argument[s], Documentation'
  call sag '   <col class="number"> <col class="type"> <col class="name"> <col>'
  call sag
  call sag '   <tbody id="meth2">'



  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
		
		p_items=ot~params~items	-- get number of arguments/parameters													
		
	 	evenOdd=choose( m//2, "odd", "even")
		
      call sag '<tr class="' || evenOdd || '">'
		call sag '    <td class="number">' m
		retType=ot~retType
		call sag '    <td align="right" valign="top"> <span class="type">'choose(retType="VT_VOID", "", retType)'</span>'
		call sag '    <td               valign="top"> <span class="name">' ts.i'</span>'
		-- call sag '    <td>'
		call sag '    <td' choose(p_items=0, 'class="indent"', "") ||'>'
		if p_items > 0 then
		do
			call sag '<strong>(</strong> '
			call write_arguments_compact ot~params
			call sag ' <strong>)</strong>'
		end
		
		if wordpos( ot~doc~string, "n/a (null)") = 0 then
		do
		   if p_items>0 then call sag '<tr class="' evenOdd '"> <td colspan="3"> <td class="indent">'
		   call sag '<span class="doc">' ot~doc~string '</span>'
		end
      call sag
     end
  end
  call sag '</tbody>'
  call sag '</table>'
	
					
	/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

  call sag '<p><hr><p>'

  Prop_totals=a~getPropertyDir~items + a~putPropertyDir~items + a~naDir~items

  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' prop_totals 'properties ...'

  call sag
  call sag '<table id="prop0" cellspacing="0" width="100%" class="compact_table">'
  call sag '   <th colspan="4" class="caption">' '<span class="hilite">' prop_totals  'Property[ies]'  '</span>'

  call sag '<tr id="meth1"><th align="right">No. <th align="right"> <th align="left">Name'
  call sag '   <th align="left">Argument[s], Documentation'
  call sag '   <col class="number"> <col class="type"> <col class="name"> <col>'
  call sag
  call sag '   <tbody id="prop2">'

  -- o=a~methodDir

  m=0
  do i=1 to ts.0
  	  tmpList=.list~new
	  tmp=a~getPropertyDir~entry(ts.i)		-- a get property?
	  getName=""
	  if tmp <> .nil then
	  do
	     tmpList~insert(tmp)
		 getName=ts.i
	  end
	
	  tmp=a~putPropertyDir~entry(ts.i)		-- a put property?
	  if tmp <> .nil then tmpList~insert(tmp)
	
	  tmp=a~naDir~entry(ts.i)				-- an unknown invoked method property?
	  if tmp <> .nil then tmpList~insert(tmp)

     do ot over tmpList			-- get all entries for
        m=m+1
        -- ot=aMD~entry(ts.i)		-- get property
		
		p_items=ot~params~items	-- get number of arguments/parameters													
		
	 	evenOdd=choose( m//2, "odd", "even")
		
      call sag '<tr class="' || evenOdd || '">'
		call sag '    <td class="number">' m
		retType=ot~retType
		call sag '    <td align="right" valign="top"> <span class="type">'choose(retType="VT_VOID", "", retType)'</span>'
		
			-- indicate the put-property by appending the assing operator "="
		call sag '    <td valign="top"> <span class="name">' ts.i || choose(ot~invKind=4, "=", "") '</span>'
		-- call sag '    <td>'
		call sag '    <td' choose(p_items=0, 'class="indent"', "") ||'>'
		if p_items > 0 then
		do
			call sag '<strong>(</strong> '
			call write_arguments_compact ot~params
			call sag ' <strong>)</strong>'
		end
		
		if wordpos( ot~doc~string, "n/a (null)") = 0 & \(ot~invKind=4 & getName=ts.i) then
		do
		   if p_items>0 then call sag '<tr class="' evenOdd '"> <td colspan="3"> <td class="indent">'
		   call sag '<span class="doc">' ot~doc~string '</span>'
		end
     end
     call sag
  end
  call sag '</tbody>'
  call sag '</table>'
	


  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

  call sag '<p><hr><p>'
		
  o=a~eventDir
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Analyzing and creating HTML-text for available' o~items 'events ...'

  call sag
  call sag '<table id="events0" cellspacing="0" width="100%" class="compact_table">'
  call sag '   <th colspan="4" class="caption">' '<span class="hilite">' o~items 'Event(s)' '<span>'
  call sag '<tr id="meth1"><th align="right">No. <th align="right">  <th align="left">Name'
  call sag '   <th align="left">Argument[s], Documentation'
  call sag '   <col valign="top" class="number"> <col class="type"> <col class="name"> <col>'
  call sag
  call sag '   <tbody id="events2">'

  ts. = a~eventSortedStem

  m=0
  do i=1 to ts.0
     if o~hasentry(ts.i) then
     do
        m=m+1
        ot=o~entry(ts.i)
		
		p_items=ot~params~items	-- get number of arguments/parameters													
		
	 	evenOdd=choose( m//2, "odd", "even")
		
        call sag '<tr class="' || evenOdd || '">'
		call sag '    <td class="number">' m
		
		call sag '    <td align="right" valign="top">'
		call sag '    <td               valign="top"> <span class="name">' ts.i'</span>'
		-- call sag '    <td>'
		call sag '    <td' choose(p_items=0, 'class="indent"', "") ||'>'
		if p_items > 0 then
		do
			call sag '<strong>(</strong> '
			call write_arguments_compact ot~params
			call sag ' <strong>)</strong>'
		end
		
		if wordpos( ot~doc~string, "n/a (null)") = 0 then
		do
		   if p_items>0 then call sag '<tr class="' evenOdd '"> <td colspan="3"> <td class="indent">'
		
		   call sag '<span class="doc">' ot~doc~string '</span>'
		end
     end
     call sag
  end
  call sag "</tbody>"
  call sag '</table>'
  call sag


  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

  /* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
  call sag
  		
  if bBrowser then	-- assuming to run under WWW-browser						
     window~status='Done.'
  return



  -- write all arguments of this method, event
write_arguments: procedure expose outMB -- outArray aIdx
  use arg ot
  if ot~items=0 then return

  call sag
  call sag '<table class="arguments">'
  call sag '<col align="right" class="number"> <col class="name">' ,
                '<col align="right" class="in"> <col class="out">' ,
                '<col class="opt"> <col class="type"'

  t=ot~items
  m=0
  do o over ot
     m=m+1
     -- call sag '<tr><td> arg #' m 'of' t':' '<td>' choose(o~opt, pp(o~name), o~name) ,
     -- call sag '<tr><td>' choose(o~opt, pp(o~name), o~name)	,
     call sag '<tr><td> #' m':' '<td>' choose(o~opt, '<span class="optional">[ ' || o~name || ' ]</span>', o~name) ,
                  '<td>' choose(o~in, "in", "")     		,
                  '<td>' choose(o~out, "/out", "") 	   ,
				  '<td>' choose(o~opt, '<span class="optional">[ optional ]</span>', "") 		,
                  '<td class="type">' o~type
  end

  call sag '</table>'

  return



  -- write all arguments of this method, event
write_arguments_compact : procedure expose outMB -- outArray aIdx
  use arg ot
  if ot~items=0 then return

  t=ot~items
  m=0
  do o over ot
     m=m+1
	 tmp =     '<span class="name">'o~name'</span>'
	
	 tmp = tmp || '&nbsp;<span class="type"><sup>'  || o~type || "</sup></span>"
	
	 if o~out then
	    tmp = tmp || '&nbsp;<span class="inout">' || choose(o~in, "in/", "---") || "out</span>"
		
				
	 call sag choose( o~opt, '<span class="optional">'pp('&nbsp;'tmp'&nbsp;')"</span>" , tmp)
	 if m <> t then		-- if not last argument, add comma
	    call sag " <strong>,</strong>"	
  end
  return


	
	-- save text in array
sag: procedure expose outMB -- outArray aIdx

  outMB~~append(arg(1))~~append("0d0a"x)
  return

	-- cheap "pretty" print
pp: procedure
  return "[" || arg(1)~string || "]"

