/*
   name:    rgf_oleconstants.rex
   version: 1.00
   date:    2003-01-03, --- released
   author:  Rony G. Flatscher
   purpose: create an Object Rexx file which saves the constants of the given
            OLE/ActiveX appId/clsId in a directory called "ole.const" in the
            environment .local (and hence can be retrieved by the environment
            symbol ".ole.const")
   usage:   rgf_oleconstants appid/clsid [outfile]

            appid/clsid ... OLE/ActiveX application ID or CLSID
            outfile ....... optional name of the outputfile, otherwise STDOUT is used

                            use the above outfile in a "::requires" directive
                            which then allows you to use the defined constants,
                            e.g. ".ole.const~SWC_3RDPARTY"

            example: rexx rgf_oleconstants InternetExplorer.Application msie_const.rex
                     ... then, whenever you need to access MSIE-constants, then merely use
                         "::requires msie_const.rex" and refer to them e.g. like
                         ".ole.const~csc_navigateBack"
*/

   if arg()=0 then -- show usage
   do
      do i=1 to 999 until pos("usage:", sourceline(i)) > 0; nop; end
      do i=i to 999 while pos("*/", sourceline(i))=0;say strip(sourceline(i));end
      exit
   end


parse arg appId outFile

ole=.oleobject~new(appId)  -- get OLE proxy
if ole=.nil then
do
   .error~say(appId": could not create the OLE proxy, aborting ...")
   exit -1
end

oleconst="ole.const"  -- define directory name to store OLE constants, change if needed

   -- get OLE constants, create sortable stem
constants.=ole~getConstant
stem. = .stem~new

i=0
max=0
do idx over constants.
   idx=substr(idx,2)  -- remove leading "!" character
--   of~say(pp(idx) "=" pp(ole~getConstant(constants.idx)))
   i=i+1
   stem.i=idx || "09"x || ole~getConstant(idx)
   stem.0=i
   max=max(max, length(idx))  -- save longest constant name
end

   -- if no constants, abort
if i=0 then
do
   .error~say("No constants found for:" pp(appId)", aborting ..." )
   exit -1
end

call SysStemSort "stem.", "A", "I"  -- sort stem

   -- dump infos
parse source . . thisPgm

   -- open file-stream
if outfile="" then of=.output -- appId"_constants.rex"
              else of=.stream~new(strip(outFile))~~open("write replace")

of~say("/*" pp(filespec("name", thisPgm)) "run on:" pp(date("s")) pp(time()) "*/" )
of~say
of~say("-- OLE/ActiveX-application/clsid:" pp(appId) "- there is/are" pp(stem.0) "constants" )
of~say
of~say("-- create directory '"OLECONST"', if necessary; maybe shared with OLE constant definitions of other programs")
of~say("if .local~hasentry('"oleconst"')=.false then .local~"oleconst"=.directory~new -- create directory '"OLEconst"' in .local")
of~say

do i=1 to stem.0
  -- of~say(pp(i) "=" pp(stem.i))
  parse var stem.i const "09"x value
  of~say( '.'oleconst'~'left(const, max) '=' encode(value) )
end

of~close

::routine pp
  return "[" || arg(1)~string || "]"

::routine encode  -- if a number, leave unchanged, else escape quotes Rexx-style, enclose string into quotes
  if datatype(arg(1), "Number") then return arg(1)  -- if a number, return value unchanged

  quote='"'
  tmp=changestr(quote, arg(1), quote||quote)
  return quote || tmp || quote
