/*
 * Run:
 *    regina time_t.rex time_offset
 */
Numeric Digits 10 /* minimum DIGITS */
Parse Arg offset
If offset = '' Then
   Do
      Say 'How about an offset in format: hh:mm:ss'
      Exit 0
   End
Parse Arg hh ':' mm ':' ss
secs = ss + (mm * 60) + ( hh * 3600 )
now = Time( 'T' )
Say 'It is now: ' Time( 'N', now, 'T' ) 'on' Date( 'N', now, 'T' ) '('now 'as time_t)'
then = now + secs
Say 'It will be:' Time( 'N', then, 'T' ) 'on' Date( 'N', then, 'T' ) 'in' offset
Return 0
