dir = arg(1)
if stream(dir || "/rexxsaa.c", "C", "Query exists") = "" then do
   say ""
   say "Give the path to Regina as the argument."
   say ""
   exit 1
   end
files = dir || "/*.c" dir || "/*.c"

/* Fetch some infos about the files we have to work with */
ADDRESS SYSTEM "/bin/ls" files "| wc -l" WITH output stem o1.
ADDRESS SYSTEM "/bin/cat" files "| wc -c -l" WITH output stem o2.
say word(o1.1, 1) "files," word(o2.1, 1) "lines," word(o2.1, 2) "chars"

say "---------- executed all files at once ----------"

call time 'r'
ADDRESS SYSTEM "/bin/cat" files ">/dev/null"
say "cat >/dev/null                          =" format(time('e'), 2, 3)

call time 'r'
ADDRESS SYSTEM "/bin/cat" files "| cat >/dev/null"
say "cat | cat >/dev/null                    =" format(time('e'), 2, 3)

call time 'r'
ADDRESS SYSTEM "/bin/cat" files WITH OUTPUT REPLACE STREAM "/tmp/rextest1"
ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT STREAM "/tmp/rextest1"
say "cat | ADDR STREAM | cat >/dev/null      =" format(time('e'), 2, 3)

call time 'r'
ADDRESS SYSTEM "/bin/cat" files WITH OUTPUT REPLACE STREAM "/tmp/rextest1"
call cpio
ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT STREAM "/tmp/rextest2"
say "cat | ADDR STREAM w/IO | cat >/dev/null =" format(time('e'), 2, 3)

call time 'r'
ADDRESS SYSTEM "/bin/cat" files WITH OUTPUT REPLACE STEM blob.
ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT STEM blob.
say "cat | ADDR STEM | cat >/dev/null        =" format(time('e'), 2, 3)

call time 'r'
ADDRESS SYSTEM "/bin/cat" files WITH OUTPUT REPLACE FIFO "f"
ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT FIFO "f"
say "cat | ADDR FIFO | cat >/dev/null        =" format(time('e'), 2, 3)

say "------ executed individually, summarised -------"

/* We process the files one after the other, applying the different steps */
/* to each file before processing the next.                               */
files = dir || "/*.c" dir || "/*.c"
ADDRESS SYSTEM "ls" files WITH OUTPUT FIFO ""
cs = 0
cp = 0
cps = 0
cbs = 0
cbp = 0
cbps = 0
cc = 0
cstream = 0
cstreamIO = 0
cstem = 0
cfifo = 0
do while queued() > 0
   parse pull file

   call time 'r'
   ADDRESS SYSTEM "cat" file ">/dev/null"
   cs = cs + time('e')

   call time 'r'
   ADDRESS PATH "cat" file WITH OUTPUT STREAM ">/dev/null"
   cp = cp + time('e')

   call time 'r'
   ADDRESS SYSTEM "cat" file WITH OUTPUT STREAM ">/dev/null"
   cps = cps + time('e')

   call time 'r'
   ADDRESS SYSTEM "/bin/cat" file ">/dev/null"
   cbs = cbs + time('e')

   call time 'r'
   ADDRESS PATH "/bin/cat" file WITH OUTPUT STREAM ">/dev/null"
   cbp = cbp + time('e')

   call time 'r'
   ADDRESS SYSTEM "/bin/cat" file WITH OUTPUT STREAM ">/dev/null"
   cbps = cbps + time('e')

   call time 'r'
   ADDRESS SYSTEM "/bin/cat" file "| cat >/dev/null"
   cc = cc + time('e')

   call time 'r'
   ADDRESS SYSTEM "/bin/cat" file WITH OUTPUT REPLACE STREAM "/tmp/rextest1"
   ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT STREAM "/tmp/rextest1"
   cstream = cstream + time('e')

   call time 'r'
   ADDRESS SYSTEM "/bin/cat" file WITH OUTPUT REPLACE STREAM "/tmp/rextest1"
   call cpio
   ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT STREAM "/tmp/rextest2"
   cstreamIO = cstreamIO + time('e')

   call time 'r'
   ADDRESS SYSTEM "/bin/cat" file WITH OUTPUT REPLACE STEM blob.
   ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT STEM blob.
   cstem = cstem + time('e')

   call time 'r'
   ADDRESS SYSTEM "/bin/cat" file WITH OUTPUT REPLACE FIFO "f"
   ADDRESS SYSTEM "/bin/cat" ">/dev/null" WITH INPUT FIFO "f"
   cfifo = cfifo + time('e')

   drop blob.
   call rxqueue 'D', "f"
   end

say "cat >/dev/null (using ADDR SYSTEM)      =" format(cs,        2, 3)
say "cat >/dev/null (using ADDR PATH WITH)   =" format(cp,        2, 3)
say "cat >/dev/null (using ADDR SYSTEM WITH) =" format(cps,       2, 3)
say "catb>/dev/null (using ADDR SYSTEM)      =" format(cbs,       2, 3)
say "catb>/dev/null (using ADDR PATH WITH)   =" format(cbp,       2, 3)
say "catb>/dev/null (using ADDR SYSTEM WITH) =" format(cbps,      2, 3)
say "cat | cat >/dev/null                    =" format(cc,        2, 3)
say "cat | ADDR STREAM | cat >/dev/null      =" format(cstream,   2, 3)
say "cat | ADDR STREAM w/IO | cat >/dev/null =" format(cstreamIO, 2, 3)
say "cat | ADDR STEM | cat >/dev/null        =" format(cstem,     2, 3)
say "cat | ADDR FIFO | cat >/dev/null        =" format(cfifo,     2, 3)
return 0

/* cpio is a helper routine copying /tmp/rextest1 to */
/* /tmp/rextest2 line by line.                       */
cpio: procedure
   call stream "/tmp/rextest1", "C", "OPEN READ"
   call stream "/tmp/rextest2", "C", "OPEN WRITE REPLACE"
   signal on notready
   do forever
      call lineout "/tmp/rextest2", linein("/tmp/rextest1")
      end
notready:
   call stream "/tmp/rextest1", "C", "CLOSE"
   call stream "/tmp/rextest2", "C", "CLOSE"
   return
