/*
 * ContainerLike example of GCI.
 * Prerequisites: 1) GCI builtin by the interpreter.
 *                2) Regina for RxFuncErrMsg()
 *                3) array.rexx in the same path.
 */
parse source . . src
array = substr(src, 1, lastPos('/', src)) || "array.rexx"
trace o
address rexx array with output fifo ""
if .rs \= 0 then do
   say ""
   say "Error invoking" array
   end

Group.0 = 4
Group.1.type = "indirect string256"
Group.1.name = "gr_name"
Group.2.type = "indirect string256"
Group.2.name = "gr_passwd"
Group.3.type = "unsigned"
Group.3.name = "gr_gid"
Group.4.type = "unsigned"
Group.4.name = "char **gr_mem, not needed"

aStem.calltype = "cdecl as function"
aStem.0 = 5
aStem.1.type = "unsigned"
aStem.1.name = "gid"
aStem.2.type = "indirect container like Group"
aStem.2.name = "result_buf"
aStem.3.type = "indirect string2048"
aStem.3.name = "buf"
aStem.4.type = "unsigned"
aStem.4.name = "buflen"
aStem.5.type = "indirect container"
aStem.5.name = "1. step of Group**"
aStem.5.0 = 1
aStem.5.1.type = "indirect container like Group"
aStem.5.1.name = "2. step of Group**"
aStem.return.type = "integer"
aStem.return.name = "error code"
call RxFuncDefine "GETGRGID", "libc.so.6",,
                  "getgrgid_r", aStem

if result \= 0 then do
   say "Error" result":" RxFuncErrMsg()
   return 1
   end

parse pull line /* The line "Member of..." */
say line

do queued()
   parse pull id
   call showGroup id
   end
return 0

showGroup: procedure
   /*
    * Sometimes setting a stem's default value is
    * convenient to inhibit GCI's picky errors.
    */
   drop bStem.
   bStem.0 = 5
   bStem.1.value = arg(1)
   bStem.1.name = "gid"
   bStem.2.value = 4 /* no NULL pointer! */
   bStem.2.3.value = 0
   bStem.2.4.value = 0
   bStem.3.value = ""
   bStem.3.name = "buf"
   bStem.4.value = 2048
   bStem.4.name = "buflen"
   signal on syntax
   bStem.5.value = 1 /* no NULL pointer! */
   err = GetGrGid(bStem)
   if err \= 0 then
      say "Error encountered:" errortext(100+err)
   else do
      say bStem.5.1.3.value "=" bStem.5.1.1.value
      end
   return
