/*
 * Container example of GCI.
 * Prerequisites: 1) GCI builtin by the interpreter.
 *                2) Regina for RxFuncErrMsg()
 */
aStem.calltype = "cdecl as function"
aStem.0 = 1
aStem.1.type = "indirect container"
aStem.1.name = "PRXSTRING VersionString"
aStem.1.0 = 2
aStem.1.1.type = "unsigned32"
aStem.1.1.name = "strlength"
aStem.1.2.type = "indirect string256"
aStem.1.2.name = "strptr"
aStem.return.type = "unsigned32"
aStem.return.name = "version coded in lower 16-bit"
call RxFuncDefine "REGINAVERSION", "libregina.so",,
                  "ReginaVersion", aStem

if result \= 0 then do
   say "Error" result":" RxFuncErrMsg()
   return 1
   end

/*
 * Pass a NULL pointer to force Regina allocating a
 * new one.
 * To do so, let bStem.1.2.value be unset.
 */
bStem.1.value = 2
bStem.1.name = "#arguments"
bStem.1.1.value = 0
bStem.1.1.name = "strlength"
bStem.1.2.name = "strptr"
/* unset bStem.1.2.value means nul-value */
version = ReginaVersion(bStem)
say "Regina's library has version" version % 256 || ,
                               "." version // 256
say "Regina's library identifies itself as" bStem.1.2.value
