/*
 * Array example of GCI.
 * Prerequisites: 1) GCI builtin by the interpreter.
 *                2) Regina for RxFuncErrMsg()
 */
aStem.calltype = "cdecl as function"
aStem.0 = 2
aStem.1.type = "integer"
aStem.1.name = "#elements"
aStem.2.type = "indirect array"
aStem.2.name = "list"
aStem.2.0 = 512
aStem.2.1.type = "unsigned32"
aStem.2.1.name = "group ID"
aStem.return.type = "integer"
aStem.return.name = "#filled elements"
call RxFuncDefine "GETGROUPS", "libc.so.6",,
                  "getgroups", aStem

if result \= 0 then do
   say "Error" result":" RxFuncErrMsg()
   return 1
   end

/*
 * Sometimes setting a stem's default value is
 * convenient to inhibit GCI's picky errors.
 */
bStem. = 0
bStem.0 = 2
bStem.1.value = 512
bStem.1.name = "#elements"
bStem.2.value = 512
bStem.2.name = "#array elements"
count = getgroups(bStem)
if count = -1 then do
   say "Sorry, error reading group list"
   return 1
   end

say "Member of these groups:"
do i = 1 to count
   say bStem.2.i.value
   end
