/*
 * tkclient.rexx generated by makerexxtk.rexx on 30 Apr 1999 at 08:48:55
 *
 * Widgets defined in UI: connect.ui
   .databaseEntry (type: entry) (variable: database)
   .versionLabel (type: label)
   .frame#1.connectButton (type: button) (function: DoConnectButton)
   .frame#1.quitButton (type: button) (function: DoQuit)
   .label#1 (type: label)
   .userNameLabel (type: label)
   .usernameEntry (type: entry) (variable: username)
   .passwordLabel (type: label)
   .frame#1 (type: frame)
   .passwordEntry (type: entry) (variable: password)
   .databaseLabel (type: label)
 * Widgets defined in UI: update.ui
   .ratingScale (type: scale)
   .label#1 (type: label) (variable: heading)
   .frame#1.button#2 (type: button) (function: DoAdd)
   .label#2 (type: label)
   .frame#1.disconnectButton (type: button) (function: DoDisconnect)
   .label#3 (type: label)
   .talkEntry (type: entry)
   .frame#1.quitButton (type: button) (function: DoQuit)
   .frame#1 (type: frame)
   .commentsEntry (type: entry)
 * Widgets defined in UI: error.ui
   .okButton (type: button) (function: DoOK)
   .errorLabel (type: label)
 */
Trace o

   Parse Arg port host
   If Datatype(port) \= 'NUM' Then Call Abort 'Port not numeric'
   If host = '' Then Call Abort 'No target machine specified'
   
   Call RxFuncAdd 'TkLoadFuncs', 'rexxtk', 'TkLoadFuncs'
   Call TkLoadFuncs
   
   Call RxFuncAdd 'SockLoadFuncs', 'rxsock', 'SockLoadFuncs'
   Call SockLoadFuncs
      
   connected = 0
   Call InitialiseComms
   
   Call SetupMainWindow
   
   /*
    * Our 'normal' Rexx/Tk loop
    */
   Do Forever
      Interpret 'Call' TkWait()
   End
   
   Return

SetupMainWindow:
   /*
    * Load the UI Tcl code, but don't execute it
    */
   Call TkTcl 'source', 'connect.ui.tcl'
   Call TkTcl 'source', 'update.ui.tcl'
   Call TkTcl 'source', 'error.ui.tcl'
   /*
    * Add any other setup code here
    */
   
   /*
    * The first ui file will be executed
    */
   Call TkTcl 'connect_ui', '.'
   
   Call TkWm 'title', '.', 'Rexx/Tk Demo'
   Call TkFocus '.usernameEntry'
   Call TkVar 'password', ''
   Parse Version ver .
   Call TkConfig '.versionLabel', '-text', ver
   
   Return

/*
 * This function is called from the .frame#1.connectButton widget in UI: connect.ui
 */
DoConnectButton:
   /*
    * Process connection
    */
   username = TkGet('.usernameEntry')
   password = TkGet('.passwordEntry')
   database = TkGet('.databaseEntry')
   If username = '' Then
      Do
         Call DisplayMessage 'Please supply a username'
         Call TkFocus '.usernameEntry'
         Return
      End
   If password = '' Then
      Do
         Call DisplayMessage 'Please supply a password'
         Call TkFocus '.passwordEntry'
         Return
      End
   
   /*
    * Connect to database
    */
   msg = DatabaseConnect( username, password, database )
   If msg \= 'OK' Then
      Do
         Call DisplayMessage msg
         Call TkFocus '.usernameEntry'
         Return
      End
   connected = 1
   
   Call TkWm 'iconify', '.'
   
   /* make a new toplevel window to load our UI update into */
   Call TkToplevel '.update'
   
   /* create and display the window using the new toplevel */
   Call TkTcl 'update_ui', '.update'
   
   Parse Source src .
   heading = 'This program demonstrates the use of two external function',
                'packages: RxSock and Rexx/Tk.  It allows a user on this',
                'environment;' src 'to connect to another environment;' remote_src 'and',
                'insert data into a database running on that',
                'environment. This is the "client" side of the application.'
   Call TkVar 'heading', heading
   Call TkFocus '.update.talkEntry'
   Call TkWm 'title', '.update', 'Rexx/Tk Demo'
   Return

/*
 * This function is called from the .frame#1.button#2 widget in UI: update.ui
 */
DoAdd:
   talk = TkGet('.update.talkEntry')
   comments = TkGet('.update.commentsEntry')
   rating = TkGet('.update.ratingScale')
   Call DatabaseInsert talk, comments, rating
   Call TkDelete '.update.talkEntry', 0, 'end'
   Call TkDelete '.update.commentsEntry', 0, 'end'
   Call TkFocus '.update.talkEntry'
   Return

/*
 * This function is called from the .frame#1.disconnectButton widget in UI: update.ui
 */
DoDisconnect:
   Call DatabaseDisconnect
   Call TkDestroy '.update'
   Call TkWm 'deiconify', '.'
   Call TkVar 'password', ''
   Call TkFocus '.passwordEntry'
   Return

/*
 * This function is called from the .frame#1.quitButton widget in UI: connect.ui
 * This function is called from the .frame#1.quitButton widget in UI: update.ui
 */
DoQuit:
   If connected = 1 Then Call DoDisconnect
   Call SendData 'X'
   Call SockClose socket
   Exit 0

DisplayMessage:
   Parse Arg msg
   /* make a new toplevel window to load our UI error into */
   Call TkToplevel '.error'

   /* grab it straight off and set focus */
   Call TkGrab '.error'
   Call TkFocus '.error'
   
   /* create and display the window using the new toplevel */
   Call TkTcl 'error_ui', '.error'
   Call TkWm 'title', '.error', 'Rexx/Tk Error'
   Call TkConfig '.error.errorLabel', '-text', msg
   Return

/*
 * This function is called from the .okButton widget in UI: error.ui
 */
DoOK:
   Call TkDestroy '.error'
   Return

/*
 * Set up the initial comms to get a connection to the server
 */
InitialiseComms:
   If SockGetHostByName(host, 'host.!') = 0 Then Call Abort SockpSock_Errno()
   server.!family = 'AF_INET'
   server.!port   = port
   server.!addr   = host.!addr
   /* 
    * Get a stream socket. 
    */
   socket = SockSocket('AF_INET', 'SOCK_STREAM', 0)
   If socket < 0 Then Call Abort SockpSock_Errno()
   
   /* 
    * Connect to the server. 
    */
   If SockConnect( socket, 'server.!') < 0 Then Call Abort SockpSock_Errno()
   /*
    * Get the remote server type
    */
   If SockRecv( socket, 'buflen', 3 ) = -1 Then Call Abort SockpSock_Errno()
   If SockRecv( socket, 'remote_src', buflen ) = -1 Then Call Abort SockpSock_Errno()
   
   Return

/*
 * Forward the database connect information to the other environment
 */
DatabaseConnect:
   Parse Arg username, password, database
   Return SendData( 'C', username, password, database )

/*
 * Forward the database disconnect information to the other environment
 */
DatabaseDisconnect:
   connected = 0
   Return SendData( 'D' )

/*
 * Forward the insertion data to the other environment
 */
DatabaseInsert:
   Parse Arg talk, comments, rating
   Return SendData( 'A', talk, comments, rating )

/*
 * Format the data for our communications protocol
 */
SendData:
   Parse Arg cmd
   Select
      When cmd = 'C' Then
         Do
            numfields = '003'
            data = numfields || Right(Length(arg(2)),3,'0') || arg(2) || Right(Length(arg(3)),3,'0') || arg(3) || Right(Length(arg(4)),3,'0') || arg(4)
         End
      When cmd = 'A' Then
         Do
            numfields = '003'
            data = numfields || Right(Length(arg(2)),3,'0') || arg(2) || Right(Length(arg(3)),3,'0') || arg(3) || Right(Length(arg(4)),3,'0') || arg(4)
         End
      Otherwise data = ''
   End
   
   If SockSend( socket, cmd || Right(Length(data),3,'0') || data ) < 0 Then Call Abort SockpSock_Errno()
   If SockRecv( socket, 'buflen', 3 ) = -1 Then Call Abort SockpSock_Errno()
   If SockRecv( socket, 'buf', buflen ) = -1 Then Call Abort SockpSock_Errno()
   Return buf

/*
 * General purpose error routine
 */
Abort: Procedure
   Parse Arg msg
   Say msg
   Exit 1
