/* 
 * server.rexx -
 */
   Trace o
   Signal On Halt

   Parse Arg port
   
   If Datatype(port) \= 'NUM' Then Call Abort 'Port not numeric'
   
   Call RxFuncAdd 'SockLoadFuncs', 'rxsock', 'SockLoadFuncs'
   Call SockLoadFuncs
   
   Call RxFuncAdd 'SQLLoadFuncs', 'rexxsql', 'SQLLoadFuncs'
   Call SQLLoadFuncs
   If SQLConnect('sc', 'dba', 'sql', 'REXXSQL') \= 0 Then Call Abort 'Unable to connect to database'
   
   Call InitialiseComms
   sock.0 = 1
   sock.1 = connect_socket
   Say 'Starting Server...'
   Do Forever
      /*
       * Set up all sockets we want to wait on
       */
      Do i = 0 To sock.0
         rfd.i = sock.i
      End
      num_ready = SockSelect('rfd.','','',10)
      If num_ready < 0 Then Call Abort SockpSock_Errno()
      If num_ready = 0 Then
         Do
            Say 'fetching data...'
            Say Left('Talk',20) Left('Rating',8) 'Comments'
            Call SQLDefault( 'sc' )
            If SQLCommand( 'q1', 'select * from symposium') \= 0 Then
               Say 'Error:' sqlca.sqlerrm
            Else
               Do i = 1 To q1.talk.0
                  Say Left(q1.talk.i,20) Right(q1.rating.i,8) q1.comments.i
               End
            Iterate
         End
      Do i = 1 To rfd.0
         If rfd.i = connect_socket Then Call AddClient
         Else Call GetClientMessage rfd.i
      End
   End
   Return 0

/*
 * This function called when a new client has connected
 */
AddClient:
   data_socket = SockAccept(connect_socket)
   If data_socket = -1 Then Call Abort SockpSock_Errno()
   If SockSetSockOpt(data_socket, 'SOL_SOCKET', 'SO_REUSEADDR', 1) < 0 Then Call Abort SockpSock_Errno()
   num_sockets = sock.0 + 1
   sock.num_sockets = data_socket
   sock.0 = num_sockets
   Parse Source src .
   src_len = Right(Length(src),3,'0')
   If SockSend(data_socket, src_len || src) < 0 Then Call Abort SockpSock_Errno()
   Return
/*
 * This function receives a message from a client and returns 'OK'
 */
GetClientMessage:
Parse Arg socknum
   If SockRecv(socknum, 'buf', 4) = -1 Then Call Abort SockpSock_Errno()
   cmd = Substr(buf, 1, 1)
   length = Substr(buf, 2)
   Select
      When cmd = 'X' Then 
            Do
               Say 'Client Exiting'
               retdata = 'OK'
            End
         When cmd = 'D' Then
            Do
               Say 'Client Disconnecting'
               Call SQLDisconnect( 'c' || socknum )
               retdata = 'OK'
            End
         When cmd = 'C' | cmd = 'A' Then
            Do
               If SockRecv(socknum, 'buf', length) = -1 Then Call Abort SockpSock_Errno()
               num_fields = Substr(buf,1,3)
               len1 = Substr(buf,4,3)
               field1 = Substr(buf,7,len1)
               len2 = Substr(buf,len1+7,3)
               field2 = Substr(buf,len1+7+3,len2)
               len3 = Substr(buf,4+len1+3+len2+3,3)
               field3 = Substr(buf,4+len1+3+len2+3+3,len3)
               retdata = 'OK'
               If cmd = 'C' Then
                  Do
                     Say 'Client Connecting'
                     rc = SQLConnect('c' || socknum, field1, field2, field3)
                     Select
                        When rc = -1 Then retdata = sqlca.sqlerrm
                        When rc = 0 Then Nop
                        Otherwise retdata = sqlca.interrm
                     End
                  End
               Else
                  Do
                     Say 'Row being added'
                     Call SQLDefault( 'c' || socknum )
                     rc = SQLCommand('i' || socknum, "insert into symposium values ('"field1"', '"field2"', "field3")" )
                     Select
                        When rc = -1 Then retdata = sqlca.sqlerrm
                        When rc = 0 Then Nop
                        Otherwise retdata = sqlca.interrm
                     End
                  End
            End
         Otherwise Nop
   End
   If SockSend(socknum, Right(Length(retdata),3,'0') || retdata) < 0 then Call Abort SockpSock_Errno()
   If cmd = 'X' Then
      Do
         Call SockClose socknum
         num_sockets = sock.0
         j = 1
         Do i = 1 To num_sockets
            If sock.i = socknum Then j = j + 1
            sock.i = sock.j
            j = j + 1
         End
         sock.0 = num_sockets - 1
      End
   Return

InitialiseComms:
   connect_socket = SockSocket('AF_INET', 'SOCK_STREAM', 0)
   If connect_socket < 0 Then Call Abort SockpSock_Errno()

   server.!family = 'AF_INET';
   server.!port = port;
   server.!addr = 'INADDR_ANY';

   If SockBind(connect_socket, 'server.!') < 0 Then Call Abort SockpSock_Errno()
   If SockListen(connect_socket, 1) \= 0 Then Call Abort SockpSock_Errno()
   If SockSetSockOpt(connect_socket, 'SOL_SOCKET', 'SO_REUSEADDR', 1) < 0 Then Call Abort SockpSock_Errno()

   Return

/*
 * General purpose error routine
 */
Abort: Procedure
   Parse Arg msg
   Say msg
   Exit 1

Halt:
   Call SockClose connect_socket
   Say 'Shutting down server.'
   Exit 0
