/*
 * cursesclient.rexx
 */
Trace o

   Parse Arg port host
   If Datatype(port) \= 'NUM' Then Call Abort 'Port not numeric'
   If host = '' Then Call Abort 'No target machine specified'
   
   Call RxFuncAdd 'CurLoadFuncs', 'rxcurses', 'CurLoadFuncs'
   Call CurLoadFuncs
   
   Call RxFuncAdd 'SockLoadFuncs', 'rxsock', 'SockLoadFuncs'
   Call SockLoadFuncs
      
   connected = 0
   Call InitialiseComms
   
   field.1 = ''
   field.2 = ''
   field.3 = ''
   fieldno = 1
   field_row.1 = 7
   field_row.2 = 9
   field_row.3 = 11
   Call SetupMainWindow
   Call DrawError Copies(' ', COLS-2)
   Do Forever
      key = CurGetch()
      Call DrawError Copies(' ', COLS-2)
      Call CurAttrset colour.1
      Call CurBox stdscr
      Select
         When key = 'KEY_F(2)' Then
            Do
               Call DoConnect
            End
         When key = 'KEY_F(3)' Then Leave
         When key = 'KEY_F(4)' Then 
            Do
               Call DoAdd
            End
         When key = 'KEY_F(5)' Then
            Do
               Call DoDisconnect
            End
         When C2d(key) = 9 | key = 'TAB' Then
            Do
               If fieldno = 3 Then fieldno = 1
               Else fieldno = fieldno + 1
               Call DrawField fieldno
               Call CurMove field_row.fieldno, 34 + Length(field.fieldno)
               Call CurRefresh
            End
         When C2d(key) = 8 | key = 'KEY_BACKSPACE' Then
            Do
               field.fieldno = Substr(field.fieldno,1,Length(field.fieldno)-1)
               Call DrawField fieldno
               Call CurMove field_row.fieldno, 34 + Length(field.fieldno)
               Call CurRefresh
            End
         When Substr(key,1,6) = 'KEY_F(' Then Nop
         When Length(key) = 1 & C2d(key) < 32 Then Nop
         When Length(key) = 1 & Length(field.fieldno) < 20 Then /* normal keys */
            Do
               field.fieldno = field.fieldno || key
               Call DrawField fieldno
               Call CurMove field_row.fieldno, 34 + Length(field.fieldno)
               Call CurRefresh
            End
         Otherwise Nop
      End
   End
   Call DoQuit
   Return

SetupMainWindow:
   stdscr = CurInitScr()
   Call CurKeypad stdscr, 1
   Call CurCbreak
   Call CurNoEcho
   If CurHasColors() Then
      Do
         Call CurStartColor
         Call CurInitpair 1, 'COLOR_GREEN', 'COLOR_BLACK'
         Call CurInitpair 2, 'COLOR_BLACK', 'COLOR_GREEN'
         Call CurInitpair 3, 'COLOR_RED', 'COLOR_BLACK'
         colour.1 = 'COLOR_PAIR(1)'
         colour.2 = 'COLOR_PAIR(2)'
         colour.3 = 'COLOR_PAIR(3)'
      End
   Else
      Do
         colour.1 = 'A_BOLD'
         colour.2 = 'A_REVERSE'
         colour.3 = 'A_BLINK'
      End
   
   title.1 = 'This program demonstrates the use of multiple Rexx extensions in the one'
   title.2 = 'Rexx program.  This client application uses RxSock and Rexx/Curses to accept'
   title.3 = 'database changes and relay them to a server component running on another'
   title.4 = 'machine.'
   Do i = 1 To 4
      Call CurMove i, 1
      Call CurAddstr title.i
   End

   Call DrawPrompts 'Username:  ', 'Password:  ', 'Database:  '
   Call DrawBlankEntries
   Call DrawKeyline
   Call CurAttrset colour.2
   Call DrawError Copies(' ', COLS-2)
   Call CurAttrset colour.1
   Call CurBox stdscr
   Call CurMove 7,34
   Call CurRefresh
   Return

DrawPrompts:
   Parse Arg p1, p2, p3
   Call CurAttrset colour.1
   Call CurMove 7, 23
   Call CurAddstr p1
   Call CurMove 9, 23
   Call CurAddstr p2
   Call CurMove 11, 23
   Call CurAddstr p3
   Return

DrawBlankEntries:
   Do i = 1 To 3
      field.i = ''
      Call DrawField i
   End
   Return

DrawField:
   Parse Arg num
   Call CurAttrset colour.2
   Call CurMove field_row.num, 34
   If connected = 0 & num = 2 Then
      Call CurAddstr Left(Copies('*',Length(field.num)),20)
   Else
      Call CurAddstr Left(field.num,20)
   Call CurMove field_row.fieldno, 34 + Length(field.fieldno)
   Call CurRefresh
   Return


DrawKeyline:
   Call CurAttrset 'A_NORMAL'
   Call Curmove 15, 14
   If connected Then
      Call CurAddstr '               F3 - Quit   F4 - Add   F5 - Disconnect'
   Else
      Call CurAddstr 'F2 - Connect   F3 - Quit'
   Return

DrawError:
   Parse Arg msg
   Call CurAttrset colour.3
   Call CurMove LINES-2,1
   Call CurAddstr msg
   Return

/*
 * This function is called via F2 key
 */
DoConnect:
   /*
    * Process connection
    */
   
   username = field.1
   password = field.2
   database = field.3
   If Strip(username) = '' Then
      Do
         Call DrawError 'Please supply a username'
         fieldno = 1
         Call DrawField fieldno
         Return
      End
   If Strip(password) = '' Then
      Do
         Call DrawError  'Please supply a password'
         fieldno = 2
         Call DrawField fieldno
         Return
      End
   
   /*
    * Connect to database
    */
   msg = DatabaseConnect( username, password, database )
   If msg \= 'OK' Then
      Do
         Call DrawError msg
         fieldno = 1
         Call DrawField fieldno
         Return
      End
   connected = 1

   field.1 = ''
   field.2 = ''
   field.3 = ''
   fieldno = 1
   Call DrawPrompts 'Talk:      ', 'Comments:  ', 'Rating:    '
   Call DrawBlankEntries
   Call DrawKeyline
   Call CurAttrset colour.2
   Call DrawError Copies(' ', COLS-2)
   Call CurAttrset colour.1
   Call CurBox stdscr
   Call CurMove 7,34
   Call CurRefresh
   
   Return

/*
 * This function is called from the .frame#1.button#2 widget in UI: update.ui
 */
DoAdd:
   talk = field.1
   comments = field.2
   rating = field.3
   Call DatabaseInsert talk, comments, rating
   Call DrawBlankEntries
   fieldno = 1
   Call DrawField fieldno
   Return

/*
 * This function is called from the .frame#1.disconnectButton widget in UI: update.ui
 */
DoDisconnect:
   Call DatabaseDisconnect
   Call DrawPrompts 'Username:  ', 'Password:  ', 'Database:  '
   Call DrawBlankEntries
   Call DrawKeyline
   Call CurAttrset colour.2
   Call DrawError Copies(' ', COLS-2)
   Call CurMove 7,34
   Call CurRefresh
   Return

DoQuit:
   If connected = 1 Then Call DoDisconnect
   Call SendData 'X'
   Call SockClose socket
   Call CurEndwin
   Exit 0

/*
 * Set up the initial comms to get a connection to the server
 */
InitialiseComms:
   If SockGetHostByName(host, 'host.!') = 0 Then Call Abort SockpSock_Errno()
   server.!family = 'AF_INET'
   server.!port   = port
   server.!addr   = host.!addr
   /* 
    * Get a stream socket. 
    */
   socket = SockSocket('AF_INET', 'SOCK_STREAM', 0)
   If socket < 0 Then Call Abort SockpSock_Errno()
   
   /* 
    * Connect to the server. 
    */
   If SockConnect( socket, 'server.!') < 0 Then Call Abort SockpSock_Errno()
   /*
    * Get the remote server type
    */
   If SockRecv( socket, 'buflen', 3 ) = -1 Then Call Abort SockpSock_Errno()
   If SockRecv( socket, 'remote_src', buflen ) = -1 Then Call Abort SockpSock_Errno()
   
   Return

/*
 * Forward the database connect information to the other environment
 */
DatabaseConnect:
   Parse Arg username, password, database
   Return SendData( 'C', username, password, database )

/*
 * Forward the database disconnect information to the other environment
 */
DatabaseDisconnect:
   connected = 0
   Return SendData( 'D' )

/*
 * Forward the insertion data to the other environment
 */
DatabaseInsert:
   Parse Arg talk, comments, rating
   Return SendData( 'A', talk, comments, rating )

/*
 * Format the data for our communications protocol
 */
SendData:
   Parse Arg cmd
   Select
      When cmd = 'C' Then
         Do
            numfields = '003'
            data = numfields || Right(Length(arg(2)),3,'0') || arg(2) || Right(Length(arg(3)),3,'0') || arg(3) || Right(Length(arg(4)),3,'0') || arg(4)
         End
      When cmd = 'A' Then
         Do
            numfields = '003'
            data = numfields || Right(Length(arg(2)),3,'0') || arg(2) || Right(Length(arg(3)),3,'0') || arg(3) || Right(Length(arg(4)),3,'0') || arg(4)
         End
      Otherwise data = ''
   End
   
   If SockSend( socket, cmd || Right(Length(data),3,'0') || data ) < 0 Then Call Abort SockpSock_Errno()
   If SockRecv( socket, 'buflen', 3 ) = -1 Then Call Abort SockpSock_Errno()
   If SockRecv( socket, 'buf', buflen ) = -1 Then Call Abort SockpSock_Errno()
   Return buf

/*
 * General purpose error routine
 */
Abort: Procedure
   Parse Arg msg
   Say msg
   Exit 1
