#! /bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

# interface generated by SpecTcl version 1.1 from /home/mark/symposium/demo/connect.ui
#   root     is the parent window for this user interface

proc connect_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	label $base.label#1 \
		-text {Client/Server logon screen.}

	label $base.userNameLabel \
		-text Username

	entry $base.usernameEntry \
		-takefocus 1 \
		-textvariable username

	label $base.passwordLabel \
		-text Password

	entry $base.passwordEntry \
		-show * \
		-textvariable password

	label $base.databaseLabel \
		-text Database

	entry $base.databaseEntry \
		-textvariable database

	button $base.connectButton \
		-command {setRexxtk DoConnectButton} \
		-default active \
		-text Connect \
		-underline 0

	button $base.quitButton \
		-command {setRexxtk DoQuit} \
		-default normal \
		-text Quit \
		-underline 0

	label $base.versionLabel


	# Geometry management

	grid $base.frame#1 -in $root	-row 5 -column 1  \
		-columnspan 2
	grid $base.label#1 -in $root	-row 1 -column 1  \
		-columnspan 2
	grid $base.userNameLabel -in $root	-row 2 -column 1 
	grid $base.usernameEntry -in $root	-row 2 -column 2 
	grid $base.passwordLabel -in $root	-row 3 -column 1 
	grid $base.passwordEntry -in $root	-row 3 -column 2 
	grid $base.databaseLabel -in $root	-row 4 -column 1 
	grid $base.databaseEntry -in $root	-row 4 -column 2 
	grid $base.connectButton -in $base.frame#1	-row 1 -column 1 
	grid $base.quitButton -in $base.frame#1	-row 1 -column 2 
	grid $base.versionLabel -in $root	-row 6 -column 1  \
		-columnspan 2

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 0 -minsize 30
	grid rowconfigure $root 4 -weight 0 -minsize 30
	grid rowconfigure $root 5 -weight 0 -minsize 30
	grid rowconfigure $root 6 -weight 0 -minsize 22
	grid columnconfigure $root 1 -weight 0 -minsize 37
	grid columnconfigure $root 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 71
	grid columnconfigure $base.frame#1 2 -weight 0 -minsize 30
# additional interface code
# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	connect_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing connect_ui"
	    connect_ui .
	}
    }
}
